/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.sex.services;

import com.geosegbar.entities.SexEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.sex.persistence.jpa.SexRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SexService {
    private final SexRepository sexRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultSexes() {
        this.createIfNotExists("Feminino");
        this.createIfNotExists("Masculino");
    }

    private void createIfNotExists(String name) {
        if (!this.sexRepository.existsByName(name)) {
            SexEntity sex = new SexEntity();
            sex.setName(name);
            this.sexRepository.save((Object)sex);
        }
    }

    @Transactional
    public void deleteById(Long id) {
        this.sexRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Sexo n\u00e3o encontrado para exclus\u00e3o!"));
        this.sexRepository.deleteById((Object)id);
    }

    @Transactional
    public SexEntity save(SexEntity sexEntity) {
        if (this.sexRepository.existsByName(sexEntity.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe um sexo com este nome!");
        }
        return (SexEntity)this.sexRepository.save((Object)sexEntity);
    }

    @Transactional
    public SexEntity update(SexEntity sexEntity) {
        this.sexRepository.findById((Object)sexEntity.getId()).orElseThrow(() -> new NotFoundException("Sexo n\u00e3o encontrado para atualiza\u00e7\u00e3o!"));
        if (this.sexRepository.existsByNameAndIdNot(sexEntity.getName(), sexEntity.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um sexo com este nome!");
        }
        return (SexEntity)this.sexRepository.save((Object)sexEntity);
    }

    public SexEntity findById(Long id) {
        return (SexEntity)this.sexRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Sexo n\u00e3o encontrado!"));
    }

    public List<SexEntity> findAll() {
        return this.sexRepository.findAllByOrderByIdAsc();
    }

    public boolean existsByName(String name) {
        return this.sexRepository.existsByName(name);
    }

    public boolean existsByNameAndIdNot(String name, Long id) {
        return this.sexRepository.existsByNameAndIdNot(name, id);
    }

    @Generated
    public SexService(SexRepository sexRepository) {
        this.sexRepository = sexRepository;
    }
}

