/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.reading.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.infra.reading.dtos.ImportReadingsResult;
import com.geosegbar.infra.reading.services.BulkReadingImportService;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/readings-massive"})
public class ReadingImportController {
    private final BulkReadingImportService importService;

    @PostMapping
    public ResponseEntity<WebResponseEntity<ImportReadingsResult>> importExcel(@RequestParam(value="instrumentId", required=true) Long instrumentId, @RequestPart(value="file", required=true) MultipartFile file) {
        if (instrumentId == null) {
            throw new InvalidInputException("ID do instrumento n\u00e3o fornecido. Por favor, informe o instrumento para importa\u00e7\u00e3o das leituras.");
        }
        if (file == null || file.isEmpty()) {
            throw new InvalidInputException("Nenhum arquivo foi enviado. Por favor, selecione uma planilha Excel v\u00e1lida.");
        }
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
            throw new InvalidInputException("Formato de arquivo inv\u00e1lido. Por favor, envie um arquivo Excel (.xlsx ou .xls).");
        }
        ImportReadingsResult result = this.importService.importFromExcel(instrumentId, file);
        String message = String.format("Importa\u00e7\u00e3o conclu\u00edda: %d leituras processadas (%d com sucesso, %d falhas)", result.getTotalRows(), result.getSuccessCount(), result.getFailureCount());
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)result, (String)message));
    }

    @Generated
    public ReadingImportController(BulkReadingImportService importService) {
        this.importService = importService;
    }
}

