/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.question.services;

import com.geosegbar.common.enums.TypeQuestionEnum;
import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.question.persistence.jpa.QuestionRepository;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class QuestionService {
    private final QuestionRepository questionRepository;

    @Transactional
    public void deleteById(Long id) {
        this.questionRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Quest\u00e3o n\u00e3o encontrada para exclus\u00e3o!"));
        this.questionRepository.deleteById((Object)id);
    }

    @Transactional
    public QuestionEntity save(QuestionEntity question) {
        this.validateQuestionByType(question);
        return (QuestionEntity)this.questionRepository.save((Object)question);
    }

    @Transactional
    public QuestionEntity update(QuestionEntity question) {
        this.questionRepository.findById((Object)question.getId()).orElseThrow(() -> new NotFoundException("Quest\u00e3o n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        this.validateQuestionByType(question);
        return (QuestionEntity)this.questionRepository.save((Object)question);
    }

    public QuestionEntity findById(Long id) {
        return (QuestionEntity)this.questionRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Quest\u00e3o n\u00e3o encontrada!"));
    }

    public List<QuestionEntity> findAll() {
        return this.questionRepository.findAll();
    }

    private void validateQuestionByType(QuestionEntity question) {
        if (TypeQuestionEnum.CHECKBOX.equals((Object)question.getType())) {
            if (question.getOptions() == null || question.getOptions().isEmpty()) {
                throw new InvalidInputException("Quest\u00f5es do tipo CHECKBOX devem ter pelo menos uma op\u00e7\u00e3o associada!");
            }
        } else if (TypeQuestionEnum.TEXT.equals((Object)question.getType()) && question.getOptions() != null && !question.getOptions().isEmpty()) {
            throw new InvalidInputException("Quest\u00f5es do tipo TEXT n\u00e3o devem ter op\u00e7\u00f5es associadas!");
        }
    }

    @Generated
    public QuestionService(QuestionRepository questionRepository) {
        this.questionRepository = questionRepository;
    }
}

