/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.potential_damage.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.PotentialDamageEntity;
import com.geosegbar.infra.potential_damage.services.PotentialDamageService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/potential-damages"})
public class PotentialDamageController {
    private final PotentialDamageService potentialDamageService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<PotentialDamageEntity>>> getAllPotentialDamages() {
        List potentialDamages = this.potentialDamageService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)potentialDamages, (String)"Danos potenciais obtidos com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<PotentialDamageEntity>> getPotentialDamageById(@PathVariable Long id) {
        PotentialDamageEntity potentialDamage = this.potentialDamageService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)potentialDamage, (String)"Dano potencial obtido com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<PotentialDamageEntity>> createPotentialDamage(@Valid @RequestBody PotentialDamageEntity potentialDamage) {
        PotentialDamageEntity createdPotentialDamage = this.potentialDamageService.save(potentialDamage);
        WebResponseEntity response = WebResponseEntity.success((Object)createdPotentialDamage, (String)"Dano potencial criado com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<PotentialDamageEntity>> updatePotentialDamage(@PathVariable Long id, @Valid @RequestBody PotentialDamageEntity potentialDamage) {
        potentialDamage.setId(id);
        PotentialDamageEntity updatedPotentialDamage = this.potentialDamageService.update(potentialDamage);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedPotentialDamage, (String)"Dano potencial atualizado com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deletePotentialDamage(@PathVariable Long id) {
        this.potentialDamageService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Dano potencial exclu\u00eddo com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public PotentialDamageController(PotentialDamageService potentialDamageService) {
        this.potentialDamageService = potentialDamageService;
    }
}

