/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.potential_damage.services;

import com.geosegbar.entities.PotentialDamageEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.potential_damage.persistence.PotentialDamageRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class PotentialDamageService {
    private final PotentialDamageRepository potentialDamageRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultPotentialDamages() {
        this.createIfNotExists("Baixo");
        this.createIfNotExists("M\u00e9dio");
        this.createIfNotExists("Alto");
    }

    private void createIfNotExists(String name) {
        if (!this.potentialDamageRepository.existsByName(name)) {
            PotentialDamageEntity potentialDamage = new PotentialDamageEntity();
            potentialDamage.setName(name);
            this.potentialDamageRepository.save((Object)potentialDamage);
        }
    }

    @Transactional
    public void deleteById(Long id) {
        this.potentialDamageRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Dano potencial n\u00e3o encontrado para exclus\u00e3o!"));
        this.potentialDamageRepository.deleteById((Object)id);
    }

    @Transactional
    public PotentialDamageEntity save(PotentialDamageEntity potentialDamageEntity) {
        if (this.potentialDamageRepository.existsByName(potentialDamageEntity.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe um dano potencial com este nome!");
        }
        return (PotentialDamageEntity)this.potentialDamageRepository.save((Object)potentialDamageEntity);
    }

    @Transactional
    public PotentialDamageEntity update(PotentialDamageEntity potentialDamageEntity) {
        this.potentialDamageRepository.findById((Object)potentialDamageEntity.getId()).orElseThrow(() -> new NotFoundException("Dano potencial n\u00e3o encontrado para atualiza\u00e7\u00e3o!"));
        if (this.potentialDamageRepository.existsByNameAndIdNot(potentialDamageEntity.getName(), potentialDamageEntity.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um dano potencial com este nome!");
        }
        return (PotentialDamageEntity)this.potentialDamageRepository.save((Object)potentialDamageEntity);
    }

    public PotentialDamageEntity findById(Long id) {
        return (PotentialDamageEntity)this.potentialDamageRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Dano potencial n\u00e3o encontrado!"));
    }

    public List<PotentialDamageEntity> findAll() {
        return this.potentialDamageRepository.findAllByOrderByIdAsc();
    }

    @Generated
    public PotentialDamageService(PotentialDamageRepository potentialDamageRepository) {
        this.potentialDamageRepository = potentialDamageRepository;
    }
}

