/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.documentation_permission.services;

import com.geosegbar.entities.DocumentationPermissionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.permissions.documentation_permission.dtos.DocumentationPermissionDTO;
import com.geosegbar.infra.permissions.documentation_permission.persistence.DocumentationPermissionRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocumentationPermissionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentationPermissionService.class);
    private final DocumentationPermissionRepository docPermissionRepository;
    private final UserRepository userRepository;

    public List<DocumentationPermissionEntity> findAll() {
        return this.docPermissionRepository.findAll();
    }

    public DocumentationPermissionEntity findById(Long id) {
        return (DocumentationPermissionEntity)this.docPermissionRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de documenta\u00e7\u00e3o n\u00e3o encontrada com ID: " + id));
    }

    public DocumentationPermissionEntity findByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        return (DocumentationPermissionEntity)this.docPermissionRepository.findByUser(user).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de documenta\u00e7\u00e3o n\u00e3o encontrada para o usu\u00e1rio"));
    }

    @Transactional
    public DocumentationPermissionEntity createOrUpdate(DocumentationPermissionDTO permissionDTO) {
        DocumentationPermissionEntity permission;
        UserEntity user = (UserEntity)this.userRepository.findById((Object)permissionDTO.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + permissionDTO.getUserId()));
        Optional existingPermission = this.docPermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = (DocumentationPermissionEntity)existingPermission.get();
        } else {
            permission = new DocumentationPermissionEntity();
            permission.setUser(user);
        }
        permission.setViewPSB(permissionDTO.getViewPSB());
        permission.setEditPSB(permissionDTO.getEditPSB());
        permission.setSharePSB(permissionDTO.getSharePSB());
        return (DocumentationPermissionEntity)this.docPermissionRepository.save((Object)permission);
    }

    @Transactional
    public void delete(Long id) {
        if (!this.docPermissionRepository.existsById((Object)id)) {
            throw new NotFoundException("Permiss\u00e3o de documenta\u00e7\u00e3o n\u00e3o encontrada com ID: " + id);
        }
        this.docPermissionRepository.deleteById((Object)id);
    }

    @Transactional
    public void deleteByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        if (!this.docPermissionRepository.existsByUser(user)) {
            throw new NotFoundException("Permiss\u00e3o de documenta\u00e7\u00e3o n\u00e3o encontrada para o usu\u00e1rio");
        }
        this.docPermissionRepository.deleteByUser(user);
    }

    @Transactional
    public void deleteByUserSafely(Long userId) {
        try {
            UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
            if (this.docPermissionRepository.existsByUser(user)) {
                DocumentationPermissionEntity permission = (DocumentationPermissionEntity)this.docPermissionRepository.findByUser(user).get();
                user.setDocumentationPermission(null);
                permission.setUser(null);
                this.userRepository.save((Object)user);
                this.docPermissionRepository.save((Object)permission);
                this.docPermissionRepository.delete((Object)permission);
            }
        }
        catch (Exception e) {
            log.warn("Error while trying to delete documentation permission for user {}: {}", (Object)userId, (Object)e.getMessage());
        }
    }

    @Transactional
    public DocumentationPermissionEntity createDefaultPermission(UserEntity user) {
        if (this.docPermissionRepository.existsByUser(user)) {
            log.info("Documentation permission already exists for user {}", (Object)user.getId());
            return (DocumentationPermissionEntity)this.docPermissionRepository.findByUser(user).get();
        }
        DocumentationPermissionEntity permission = new DocumentationPermissionEntity();
        permission.setUser(user);
        permission.setViewPSB(Boolean.valueOf(false));
        permission.setEditPSB(Boolean.valueOf(false));
        permission.setSharePSB(Boolean.valueOf(false));
        DocumentationPermissionEntity savedPermission = (DocumentationPermissionEntity)this.docPermissionRepository.save((Object)permission);
        return savedPermission;
    }

    @Generated
    public DocumentationPermissionService(DocumentationPermissionRepository docPermissionRepository, UserRepository userRepository) {
        this.docPermissionRepository = docPermissionRepository;
        this.userRepository = userRepository;
    }
}

