/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_customization_properties.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.GraphPropertiesResponseDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.PropertyResponseDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdateGraphPropertiesRequestDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdatePropertiesBatchRequestDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdatePropertiesBatchResponseDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdatePropertyRequestDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.services.InstrumentGraphCustomizationPropertiesService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/graph-properties"})
public class InstrumentGraphCustomizationPropertiesController {
    private final InstrumentGraphCustomizationPropertiesService propertiesService;

    @PutMapping(value={"/elements/pattern/{patternId}"})
    public ResponseEntity<WebResponseEntity<Void>> updateProperties(@PathVariable Long patternId, @Valid @RequestBody UpdateGraphPropertiesRequestDTO request) {
        this.propertiesService.updateProperties(patternId, request);
        return ResponseEntity.ok((Object)WebResponseEntity.success(null, (String)"Propriedades atualizadas com sucesso!"));
    }

    @PutMapping(value={"/{propertyId}"})
    public ResponseEntity<WebResponseEntity<PropertyResponseDTO>> updateProperty(@PathVariable Long propertyId, @Valid @RequestBody UpdatePropertyRequestDTO request) {
        PropertyResponseDTO dto = this.propertiesService.updateProperty(propertyId, request);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)dto, (String)"Propriedade atualizada com sucesso!"));
    }

    @PutMapping(value={"/batch/pattern/{patternId}"})
    public ResponseEntity<WebResponseEntity<UpdatePropertiesBatchResponseDTO>> updatePropertiesBatch(@PathVariable Long patternId, @Valid @RequestBody UpdatePropertiesBatchRequestDTO request) {
        UpdatePropertiesBatchResponseDTO response = this.propertiesService.updatePropertiesBatch(patternId, request);
        Object message = String.format("Processamento conclu\u00eddo: %d propriedades atualizadas", response.getTotalUpdated());
        if (!response.getErrors().isEmpty()) {
            message = (String)message + String.format(", %d erros encontrados", response.getErrors().size());
        }
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)response, (String)message));
    }

    @GetMapping(value={"/pattern/{patternId}"})
    public ResponseEntity<WebResponseEntity<GraphPropertiesResponseDTO>> getPropertiesByPattern(@PathVariable Long patternId) {
        GraphPropertiesResponseDTO dto = this.propertiesService.findByPatternId(patternId);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)dto, (String)"Propriedades recuperadas com sucesso!"));
    }

    @Generated
    public InstrumentGraphCustomizationPropertiesController(InstrumentGraphCustomizationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }
}

