/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.hydrotelemetric.jobs;

import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.infra.hydrotelemetric.services.AnaApiService;
import com.geosegbar.infra.instrument.persistence.jpa.InstrumentRepository;
import com.geosegbar.infra.reading.dtos.ReadingRequestDTO;
import com.geosegbar.infra.reading.services.ReadingService;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class HydrotelemetricDataCollectionJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HydrotelemetricDataCollectionJob.class);
    private final AnaApiService anaApiService;
    private final InstrumentRepository instrumentRepository;
    private final ReadingService readingService;

    @Scheduled(cron="0 30 0 * * ?")
    public void collectHydrotelemetricData() {
        log.info("Iniciando coleta de dados hidrotelem\u00e9tricos");
        try {
            String authToken = this.anaApiService.getAuthToken();
            List linimetricInstruments = this.instrumentRepository.findByIsLinimetricRulerTrue();
            log.info("Encontrados {} instrumentos do tipo r\u00e9gua linim\u00e9trica", (Object)linimetricInstruments.size());
            LocalDate today = LocalDate.now();
            for (InstrumentEntity instrument : linimetricInstruments) {
                try {
                    this.collectInstrumentData(instrument, authToken, today);
                }
                catch (Exception e) {
                    log.error("Erro ao coletar dados para o instrumento {}: {}", new Object[]{instrument.getName(), e.getMessage(), e});
                }
            }
            log.info("Coleta de dados hidrotelem\u00e9tricos finalizada com sucesso");
        }
        catch (Exception e) {
            log.error("Erro durante a coleta de dados hidrotelem\u00e9tricos: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Transactional(timeout=60)
    private void collectInstrumentData(InstrumentEntity instrument, String authToken, LocalDate date) {
        Long linimetricCode = instrument.getLinimetricRulerCode();
        if (linimetricCode == null) {
            log.warn("Instrumento {} n\u00e3o possui c\u00f3digo de r\u00e9gua linim\u00e9trica. Ignorando.", (Object)instrument.getName());
            return;
        }
        boolean readingExists = this.readingService.existsByInstrumentAndDate(instrument.getId(), date);
        if (readingExists) {
            log.info("J\u00e1 existe leitura para o instrumento {} na data {}. Ignorando.", (Object)instrument.getName(), (Object)date);
            return;
        }
        try {
            Double averageM;
            String stationCode = String.valueOf(linimetricCode);
            List telemetryData = this.anaApiService.getTelemetryData(stationCode, authToken);
            Double averageMm = this.anaApiService.calculateAverageLevel(telemetryData, date);
            Double d = averageM = averageMm != null ? Double.valueOf(averageMm / 1000.0) : null;
            if (averageM == null) {
                log.warn("Valor nulo obtido para instrumento: {}. Nenhuma leitura ser\u00e1 registrada.", (Object)instrument.getName());
                return;
            }
            String inputAcronym = "LEI";
            boolean hasRequiredInput = instrument.getInputs().stream().anyMatch(input -> input.getAcronym().equals(inputAcronym));
            if (!hasRequiredInput) {
                log.error("Instrumento {} n\u00e3o possui o input necess\u00e1rio '{}'. Ignorando.", (Object)instrument.getName(), (Object)inputAcronym);
                return;
            }
            ReadingRequestDTO readingRequest = new ReadingRequestDTO();
            readingRequest.setDate(date);
            readingRequest.setHour(LocalTime.of(0, 30));
            HashMap<String, Double> inputValues = new HashMap<String, Double>();
            inputValues.put(inputAcronym, averageM);
            readingRequest.setInputValues(inputValues);
            readingRequest.setComment("Leitura autom\u00e1tica pela ANA.");
            this.readingService.create(instrument.getId(), readingRequest, true);
            log.info("Leitura linim\u00e9trica registrada com sucesso para instrumento: {} - Valor: {}m", (Object)instrument.getName(), (Object)averageM);
        }
        catch (Exception e) {
            log.error("Erro ao coletar dados para instrumento {}: {}", (Object)instrument.getName(), (Object)e.getMessage());
            throw e;
        }
    }

    @Transactional
    public void collectDataManually() {
        this.collectHydrotelemetricData();
    }

    @Generated
    public HydrotelemetricDataCollectionJob(AnaApiService anaApiService, InstrumentRepository instrumentRepository, ReadingService readingService) {
        this.anaApiService = anaApiService;
        this.instrumentRepository = instrumentRepository;
        this.readingService = readingService;
    }
}

