/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.danger_level.services;

import com.geosegbar.entities.DangerLevelEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.danger_level.persistence.jpa.DangerLevelRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DangerLevelService {
    private final DangerLevelRepository dangerLevelRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultDangerLevels() {
        this.createIfNotExists("Normal", "Condi\u00e7\u00f5es normais de opera\u00e7\u00e3o");
        this.createIfNotExists("Aten\u00e7\u00e3o", "Anomalia que requer aten\u00e7\u00e3o e verifica\u00e7\u00e3o peri\u00f3dica");
        this.createIfNotExists("Alerta", "Anomalia com risco potencial que requer interven\u00e7\u00e3o");
        this.createIfNotExists("Emerg\u00eancia", "Anomalia cr\u00edtica que requer a\u00e7\u00e3o imediata");
        this.createIfNotExists("--", "Ainda n\u00e3o foi definido um n\u00edvel de perigo");
    }

    private void createIfNotExists(String name, String description) {
        Optional existingLevel = this.dangerLevelRepository.findByName(name);
        if (existingLevel.isEmpty()) {
            DangerLevelEntity dangerLevel = new DangerLevelEntity();
            dangerLevel.setName(name);
            dangerLevel.setDescription(description);
            this.dangerLevelRepository.save((Object)dangerLevel);
        }
    }

    public List<DangerLevelEntity> findAll() {
        return this.dangerLevelRepository.findAll();
    }

    public DangerLevelEntity findById(Long id) {
        return (DangerLevelEntity)this.dangerLevelRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Danger level not found!"));
    }

    public DangerLevelEntity findByName(String name) {
        return (DangerLevelEntity)this.dangerLevelRepository.findByName(name).orElseThrow(() -> new NotFoundException("Danger level not found with name: " + name));
    }

    @Generated
    public DangerLevelService(DangerLevelRepository dangerLevelRepository) {
        this.dangerLevelRepository = dangerLevelRepository;
    }
}

