/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.dam.services;

import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.entities.ClassificationDamEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DocumentationDamEntity;
import com.geosegbar.entities.LevelEntity;
import com.geosegbar.entities.PotentialDamageEntity;
import com.geosegbar.entities.RegulatoryDamEntity;
import com.geosegbar.entities.ReservoirEntity;
import com.geosegbar.entities.RiskCategoryEntity;
import com.geosegbar.entities.SecurityLevelEntity;
import com.geosegbar.entities.StatusEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.UnauthorizedException;
import com.geosegbar.infra.classification_dam.peristence.ClassificationDamRepository;
import com.geosegbar.infra.client.persistence.jpa.ClientRepository;
import com.geosegbar.infra.dam.dtos.CreateDamCompleteRequest;
import com.geosegbar.infra.dam.dtos.LevelRequestDTO;
import com.geosegbar.infra.dam.dtos.ReservoirRequestDTO;
import com.geosegbar.infra.dam.dtos.UpdateDamRequest;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.documentation_dam.persistence.DocumentationDamRepository;
import com.geosegbar.infra.file_storage.FileStorageService;
import com.geosegbar.infra.level.persistence.LevelRepository;
import com.geosegbar.infra.potential_damage.persistence.PotentialDamageRepository;
import com.geosegbar.infra.psb.services.PSBFolderService;
import com.geosegbar.infra.regulatory_dam.persistence.RegulatoryDamRepository;
import com.geosegbar.infra.reservoir.persistence.ReservoirRepository;
import com.geosegbar.infra.risk_category.persistence.RiskCategoryRepository;
import com.geosegbar.infra.security_level.persistence.SecurityLevelRepository;
import com.geosegbar.infra.status.persistence.jpa.StatusRepository;
import jakarta.transaction.Transactional;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.hibernate.Hibernate;
import org.springframework.stereotype.Service;

@Service
public class DamService {
    private final DamRepository damRepository;
    private final ClientRepository clientRepository;
    private final StatusRepository statusRepository;
    private final SecurityLevelRepository securityLevelRepository;
    private final RiskCategoryRepository riskCategoryRepository;
    private final PotentialDamageRepository potentialDamageRepository;
    private final ClassificationDamRepository classificationDamRepository;
    private final DocumentationDamRepository documentationDamRepository;
    private final RegulatoryDamRepository regulatoryDamRepository;
    private final FileStorageService fileStorageService;
    private final LevelRepository levelRepository;
    private final ReservoirRepository reservoirRepository;
    private final PSBFolderService psbFolderService;

    public DamEntity findByIdWithSections(Long id) {
        DamEntity dam = this.findById(id);
        Hibernate.initialize((Object)dam.getSections());
        return dam;
    }

    public List<DamEntity> findAllWithSections() {
        List dams = this.findAll();
        dams.forEach(dam -> Hibernate.initialize((Object)dam.getSections()));
        return dams;
    }

    public List<DamEntity> findDamsByClientIdWithSections(Long clientId) {
        List dams = this.findDamsByClientId(clientId);
        dams.forEach(dam -> Hibernate.initialize((Object)dam.getSections()));
        return dams;
    }

    public List<DamEntity> findByClientAndStatusWithSections(Long clientId, Long statusId) {
        List dams = this.findByClientAndStatus(clientId, statusId);
        dams.forEach(dam -> Hibernate.initialize((Object)dam.getSections()));
        return dams;
    }

    @Transactional
    public DamEntity createCompleteWithRelationships(CreateDamCompleteRequest request) {
        byte[] imageBytes;
        String base64Image;
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getAttributionsPermission().getEditDam().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para criar barragens!");
        }
        if (this.damRepository.existsByNameAndClientId(request.getName(), request.getClientId())) {
            throw new DuplicateResourceException("J\u00e1 existe uma barragem com este nome para este cliente!");
        }
        ClientEntity client = (ClientEntity)this.clientRepository.findById((Object)request.getClientId()).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado"));
        StatusEntity status = (StatusEntity)this.statusRepository.findById((Object)request.getStatusId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado"));
        DamEntity dam = new DamEntity();
        dam.setName(request.getName());
        dam.setLatitude(request.getLatitude());
        dam.setLongitude(request.getLongitude());
        dam.setStreet(request.getStreet());
        dam.setNeighborhood(request.getNeighborhood());
        dam.setNumberAddress(request.getNumberAddress());
        dam.setCity(request.getCity());
        dam.setState(request.getState());
        dam.setZipCode(request.getZipCode());
        dam.setClient(client);
        dam.setStatus(status);
        dam.setLinkPSB(request.getLinkPSB());
        dam.setLinkLegislation(request.getLinkLegislation());
        if (request.getLogoBase64() != null && !request.getLogoBase64().isEmpty()) {
            base64Image = request.getLogoBase64();
            if (base64Image.contains(",")) {
                base64Image = base64Image.split(",")[1];
            }
            imageBytes = Base64.getDecoder().decode(base64Image);
            String logoUrl = this.fileStorageService.storeFileFromBytes(imageBytes, "logo.jpg", "image/jpeg", "logos");
            dam.setLogoPath(logoUrl);
        }
        if (request.getDamImageBase64() != null && !request.getDamImageBase64().isEmpty()) {
            base64Image = request.getDamImageBase64();
            if (base64Image.contains(",")) {
                base64Image = base64Image.split(",")[1];
            }
            imageBytes = Base64.getDecoder().decode(base64Image);
            String damImageUrl = this.fileStorageService.storeFileFromBytes(imageBytes, "dam_image.jpg", "image/jpeg", "dam_images");
            dam.setDamImagePath(damImageUrl);
        }
        dam = (DamEntity)this.damRepository.save((Object)dam);
        DocumentationDamEntity documentationDam = new DocumentationDamEntity();
        documentationDam.setDam(dam);
        documentationDam.setLastUpdatePAE(request.getLastUpdatePAE());
        documentationDam.setNextUpdatePAE(request.getNextUpdatePAE());
        documentationDam.setLastUpdatePSB(request.getLastUpdatePSB());
        documentationDam.setNextUpdatePSB(request.getNextUpdatePSB());
        documentationDam.setLastUpdateRPSB(request.getLastUpdateRPSB());
        documentationDam.setNextUpdateRPSB(request.getNextUpdateRPSB());
        documentationDam.setLastAchievementISR(request.getLastAchievementISR());
        documentationDam.setNextAchievementISR(request.getNextAchievementISR());
        documentationDam.setLastAchievementChecklist(request.getLastAchievementChecklist());
        documentationDam.setNextAchievementChecklist(request.getNextAchievementChecklist());
        documentationDam.setLastFillingFSB(request.getLastFillingFSB());
        documentationDam.setNextFillingFSB(request.getNextFillingFSB());
        documentationDam.setLastInternalSimulation(request.getLastInternalSimulation());
        documentationDam.setNextInternalSimulation(request.getNextInternalSimulation());
        documentationDam.setLastExternalSimulation(request.getLastExternalSimulation());
        documentationDam.setNextExternalSimulation(request.getNextExternalSimulation());
        this.documentationDamRepository.save((Object)documentationDam);
        RegulatoryDamEntity regulatoryDam = new RegulatoryDamEntity();
        regulatoryDam.setDam(dam);
        regulatoryDam.setFramePNSB(request.getFramePNSB());
        regulatoryDam.setRepresentativeName(request.getRepresentativeName());
        regulatoryDam.setRepresentativeEmail(request.getRepresentativeEmail());
        regulatoryDam.setRepresentativePhone(request.getRepresentativePhone());
        regulatoryDam.setTechnicalManagerName(request.getTechnicalManagerName());
        regulatoryDam.setTechnicalManagerEmail(request.getTechnicalManagerEmail());
        regulatoryDam.setTechnicalManagerPhone(request.getTechnicalManagerPhone());
        if (request.getSecurityLevelId() != null) {
            SecurityLevelEntity securityLevel = (SecurityLevelEntity)this.securityLevelRepository.findById((Object)request.getSecurityLevelId()).orElseThrow(() -> new NotFoundException("N\u00edvel de seguran\u00e7a n\u00e3o encontrado"));
            regulatoryDam.setSecurityLevel(securityLevel);
        }
        if (request.getSupervisoryBodyName() != null) {
            regulatoryDam.setSupervisoryBodyName(request.getSupervisoryBodyName());
        }
        if (request.getRiskCategoryId() != null) {
            RiskCategoryEntity riskCategory = (RiskCategoryEntity)this.riskCategoryRepository.findById((Object)request.getRiskCategoryId()).orElseThrow(() -> new NotFoundException("Categoria de risco n\u00e3o encontrada"));
            regulatoryDam.setRiskCategory(riskCategory);
        }
        if (request.getPotentialDamageId() != null) {
            PotentialDamageEntity potentialDamage = (PotentialDamageEntity)this.potentialDamageRepository.findById((Object)request.getPotentialDamageId()).orElseThrow(() -> new NotFoundException("Dano potencial n\u00e3o encontrado"));
            regulatoryDam.setPotentialDamage(potentialDamage);
        }
        if (request.getClassificationDamId() != null) {
            ClassificationDamEntity classificationDam = (ClassificationDamEntity)this.classificationDamRepository.findById((Object)request.getClassificationDamId()).orElseThrow(() -> new NotFoundException("Classifica\u00e7\u00e3o da barragem n\u00e3o encontrada"));
            regulatoryDam.setClassificationDam(classificationDam);
        }
        this.regulatoryDamRepository.save((Object)regulatoryDam);
        if (request.getReservoirs() != null && !request.getReservoirs().isEmpty()) {
            for (ReservoirRequestDTO reservoirDTO : request.getReservoirs()) {
                LevelEntity level = this.processLevel(reservoirDTO.getLevel());
                ReservoirEntity reservoir = new ReservoirEntity();
                reservoir.setDam(dam);
                reservoir.setLevel(level);
                this.reservoirRepository.save((Object)reservoir);
            }
        }
        if (request.getPsbFolders() != null && !request.getPsbFolders().isEmpty()) {
            List foldersList = this.psbFolderService.createMultipleFolders(dam, request.getPsbFolders(), request.getCreatedById());
            HashSet foldersSet = new HashSet(foldersList);
            dam.setPsbFolders(foldersSet);
        }
        return this.findById(dam.getId());
    }

    private LevelEntity processLevel(LevelRequestDTO levelDTO) {
        if (levelDTO.getId() != null) {
            return (LevelEntity)this.levelRepository.findById((Object)levelDTO.getId()).orElseThrow(() -> new NotFoundException("N\u00edvel n\u00e3o encontrado com ID: " + levelDTO.getId()));
        }
        return this.levelRepository.findByName(levelDTO.getName()).orElseGet(() -> {
            LevelEntity newLevel = new LevelEntity();
            newLevel.setName(levelDTO.getName());
            newLevel.setValue(levelDTO.getValue());
            newLevel.setUnitLevel(levelDTO.getUnitLevel());
            return (LevelEntity)this.levelRepository.save((Object)newLevel);
        });
    }

    public List<DamEntity> findByClientAndStatus(Long clientId, Long statusId) {
        List dams = this.damRepository.findWithDetailsByClientAndStatus(clientId, statusId);
        return dams;
    }

    @Transactional
    public void deleteById(Long id) {
        this.damRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada para exclus\u00e3o!"));
        this.damRepository.deleteById((Object)id);
    }

    @Transactional
    public DamEntity save(DamEntity damEntity) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getAttributionsPermission().getEditDam().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para criar barragens!");
        }
        if (this.damRepository.existsByNameAndClientId(damEntity.getName(), damEntity.getClient().getId())) {
            throw new DuplicateResourceException("J\u00e1 existe uma barragem com este nome para este cliente!");
        }
        DamEntity savedDam = (DamEntity)this.damRepository.save((Object)damEntity);
        return this.findById(savedDam.getId());
    }

    @Transactional
    public DamEntity updateBasicInfo(Long damId, UpdateDamRequest request) {
        byte[] imageBytes;
        String base64Image;
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getAttributionsPermission().getEditDam().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para editar barragens!");
        }
        DamEntity existingDam = (DamEntity)this.damRepository.findById((Object)damId).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + damId));
        ClientEntity client = (ClientEntity)this.clientRepository.findById((Object)request.getClientId()).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado com ID: " + request.getClientId()));
        if (!(existingDam.getName().equals(request.getName()) && existingDam.getClient().getId().equals(client.getId()) || !this.damRepository.existsByNameAndClientIdAndIdNot(request.getName(), client.getId(), damId))) {
            throw new DuplicateResourceException("J\u00e1 existe uma barragem com este nome para este cliente!");
        }
        StatusEntity status = (StatusEntity)this.statusRepository.findById((Object)request.getStatusId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado com ID: " + request.getStatusId()));
        existingDam.setName(request.getName());
        existingDam.setLatitude(request.getLatitude());
        existingDam.setLongitude(request.getLongitude());
        existingDam.setStreet(request.getStreet());
        existingDam.setNeighborhood(request.getNeighborhood());
        existingDam.setNumberAddress(request.getNumberAddress());
        existingDam.setCity(request.getCity());
        existingDam.setState(request.getState());
        existingDam.setZipCode(request.getZipCode());
        existingDam.setClient(client);
        existingDam.setStatus(status);
        existingDam.setLinkPSB(request.getLinkPSB());
        existingDam.setLinkLegislation(request.getLinkLegislation());
        if (request.getLogoBase64() != null && !request.getLogoBase64().isEmpty()) {
            if (existingDam.getLogoPath() != null) {
                this.fileStorageService.deleteFile(existingDam.getLogoPath());
            }
            if ((base64Image = request.getLogoBase64()).contains(",")) {
                base64Image = base64Image.split(",")[1];
            }
            imageBytes = Base64.getDecoder().decode(base64Image);
            String logoUrl = this.fileStorageService.storeFileFromBytes(imageBytes, "logo_" + damId + ".jpg", "image/jpeg", "logos");
            existingDam.setLogoPath(logoUrl);
        }
        if (request.getDamImageBase64() != null && !request.getDamImageBase64().isEmpty()) {
            if (existingDam.getDamImagePath() != null) {
                this.fileStorageService.deleteFile(existingDam.getDamImagePath());
            }
            if ((base64Image = request.getDamImageBase64()).contains(",")) {
                base64Image = base64Image.split(",")[1];
            }
            imageBytes = Base64.getDecoder().decode(base64Image);
            String damImageUrl = this.fileStorageService.storeFileFromBytes(imageBytes, "dam_image_" + damId + ".jpg", "image/jpeg", "dam_images");
            existingDam.setDamImagePath(damImageUrl);
        }
        DamEntity updatedDam = (DamEntity)this.damRepository.save((Object)existingDam);
        return this.findById(updatedDam.getId());
    }

    public List<DamEntity> findDamsByClientId(Long clientId) {
        List damsWithFolders = this.damRepository.findWithPsbFoldersByClientId(clientId);
        List damsWithReservoirs = this.damRepository.findWithReservoirsByClientId(clientId);
        block0: for (DamEntity dam : damsWithFolders) {
            for (DamEntity damWithReservoirs : damsWithReservoirs) {
                if (!dam.getId().equals(damWithReservoirs.getId())) continue;
                dam.setReservoirs(damWithReservoirs.getReservoirs());
                continue block0;
            }
        }
        return damsWithFolders;
    }

    public DamEntity findById(Long id) {
        DamEntity dam = (DamEntity)this.damRepository.findWithPsbFoldersById(id).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada!"));
        DamEntity damWithReservoirs = (DamEntity)this.damRepository.findWithReservoirsById(id).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada!"));
        dam.setReservoirs(damWithReservoirs.getReservoirs());
        return dam;
    }

    public List<DamEntity> findAll() {
        List dams = this.damRepository.findAll();
        for (DamEntity dam : dams) {
            DamEntity damWithDetails = this.findById(dam.getId());
            dam.setPsbFolders(damWithDetails.getPsbFolders());
            dam.setReservoirs(damWithDetails.getReservoirs());
        }
        return dams;
    }

    public boolean existsByName(String name) {
        return this.damRepository.existsByName(name);
    }

    public boolean existsByNameAndIdNot(String name, Long id) {
        return this.damRepository.existsByNameAndIdNot(name, id);
    }

    @Generated
    public DamService(DamRepository damRepository, ClientRepository clientRepository, StatusRepository statusRepository, SecurityLevelRepository securityLevelRepository, RiskCategoryRepository riskCategoryRepository, PotentialDamageRepository potentialDamageRepository, ClassificationDamRepository classificationDamRepository, DocumentationDamRepository documentationDamRepository, RegulatoryDamRepository regulatoryDamRepository, FileStorageService fileStorageService, LevelRepository levelRepository, ReservoirRepository reservoirRepository, PSBFolderService psbFolderService) {
        this.damRepository = damRepository;
        this.clientRepository = clientRepository;
        this.statusRepository = statusRepository;
        this.securityLevelRepository = securityLevelRepository;
        this.riskCategoryRepository = riskCategoryRepository;
        this.potentialDamageRepository = potentialDamageRepository;
        this.classificationDamRepository = classificationDamRepository;
        this.documentationDamRepository = documentationDamRepository;
        this.regulatoryDamRepository = regulatoryDamRepository;
        this.fileStorageService = fileStorageService;
        this.levelRepository = levelRepository;
        this.reservoirRepository = reservoirRepository;
        this.psbFolderService = psbFolderService;
    }
}

