/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.constant.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.ConstantEntity;
import com.geosegbar.infra.constant.services.ConstantService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/constants"})
public class ConstantController {
    private final ConstantService constantService;

    @GetMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<List<ConstantEntity>>> getConstantsByInstrument(@PathVariable Long instrumentId) {
        List constants = this.constantService.findByInstrumentId(instrumentId);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)constants, (String)"Constantes do instrumento obtidas com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ConstantEntity>> getConstantById(@PathVariable Long id) {
        ConstantEntity constant = this.constantService.findById(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)constant, (String)"Constante obtida com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteConstant(@PathVariable Long id) {
        this.constantService.deleteById(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success(null, (String)"Constante exclu\u00edda com sucesso!"));
    }

    @Generated
    public ConstantController(ConstantService constantService) {
        this.constantService = constantService;
    }
}

