/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist_submission.services;

import com.geosegbar.common.enums.AnomalyOriginEnum;
import com.geosegbar.common.enums.TypeQuestionEnum;
import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.entities.AnomalyEntity;
import com.geosegbar.entities.AnomalyPhotoEntity;
import com.geosegbar.entities.AnomalyStatusEntity;
import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.entities.AnswerPhotoEntity;
import com.geosegbar.entities.ChecklistEntity;
import com.geosegbar.entities.ChecklistResponseEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DangerLevelEntity;
import com.geosegbar.entities.OptionEntity;
import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.entities.QuestionnaireResponseEntity;
import com.geosegbar.entities.TemplateQuestionnaireEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.FileStorageException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.UnauthorizedException;
import com.geosegbar.infra.anomaly.persistence.jpa.AnomalyRepository;
import com.geosegbar.infra.anomaly_photo.persistence.jpa.AnomalyPhotoRepository;
import com.geosegbar.infra.anomaly_status.persistence.jpa.AnomalyStatusRepository;
import com.geosegbar.infra.answer.persistence.jpa.AnswerRepository;
import com.geosegbar.infra.answer_photo.persistence.jpa.AnswerPhotoRepository;
import com.geosegbar.infra.checklist.persistence.jpa.ChecklistRepository;
import com.geosegbar.infra.checklist_response.persistence.jpa.ChecklistResponseRepository;
import com.geosegbar.infra.checklist_submission.dtos.AnswerSubmissionDTO;
import com.geosegbar.infra.checklist_submission.dtos.ChecklistResponseSubmissionDTO;
import com.geosegbar.infra.checklist_submission.dtos.PhotoSubmissionDTO;
import com.geosegbar.infra.checklist_submission.dtos.QuestionnaireResponseSubmissionDTO;
import com.geosegbar.infra.checklist_submission.services.PVAnswerValidator;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.danger_level.persistence.jpa.DangerLevelRepository;
import com.geosegbar.infra.file_storage.FileStorageService;
import com.geosegbar.infra.option.persistence.jpa.OptionRepository;
import com.geosegbar.infra.question.persistence.jpa.QuestionRepository;
import com.geosegbar.infra.questionnaire_response.persistence.jpa.QuestionnaireResponseRepository;
import com.geosegbar.infra.template_questionnaire.persistence.jpa.TemplateQuestionnaireRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import jakarta.transaction.Transactional;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class ChecklistResponseSubmissionService {
    private final ChecklistResponseRepository checklistResponseRepository;
    private final QuestionnaireResponseRepository questionnaireResponseRepository;
    private final AnswerRepository answerRepository;
    private final AnswerPhotoRepository answerPhotoRepository;
    private final OptionRepository optionRepository;
    private final QuestionRepository questionRepository;
    private final TemplateQuestionnaireRepository templateQuestionnaireRepository;
    private final FileStorageService fileStorageService;
    private final DamService damService;
    private final UserRepository userRepository;
    private final ChecklistRepository checklistRepository;
    private final DangerLevelRepository dangerLevelRepository;
    private final AnomalyStatusRepository anomalyStatusRepository;
    private final AnomalyRepository anomalyRepository;
    private final PVAnswerValidator pvAnswerValidator;
    private final DamRepository damRepository;
    private final AnomalyPhotoRepository anomalyPhotoRepository;

    @Transactional
    @CacheEvict(value={"allChecklistResponses", "checklistResponseById", "checklistResponsesByDam", "checklistResponseDetail", "checklistResponsesByUser", "checklistResponsesByDate", "damLastChecklist", "checklistsWithAnswersByDam", "checklistsWithAnswersByClient", "checklistResponsesByDamPaged", "checklistResponsesByUserPaged", "checklistResponsesByDatePaged", "allChecklistResponsesPaged", "checklistResponsesByClient", "clientLatestDetailedChecklistResponses"}, allEntries=true, cacheManager="checklistCacheManager")
    public ChecklistResponseEntity submitChecklistResponse(ChecklistResponseSubmissionDTO submissionDto) {
        this.validateUserAccessToDam(submissionDto.getUserId(), submissionDto.getDamId());
        if (!AuthenticatedUserUtil.isAdmin()) {
            if (submissionDto.isMobile()) {
                if (!AuthenticatedUserUtil.getCurrentUser().getRoutineInspectionPermission().getIsFillMobile().booleanValue()) {
                    throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para preencher checklist via mobile!");
                }
            } else if (!submissionDto.isMobile() && !AuthenticatedUserUtil.getCurrentUser().getRoutineInspectionPermission().getIsFillWeb().booleanValue()) {
                throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para preencher checklist via web!");
            }
        }
        ChecklistResponseEntity checklistResponse = this.createChecklistResponse(submissionDto);
        this.validateAllRequiredQuestionnaires(submissionDto);
        this.validatePVAnswersHaveRequiredFields(submissionDto);
        for (QuestionnaireResponseSubmissionDTO questionnaireDto : submissionDto.getQuestionnaireResponses()) {
            this.validateAllQuestionsAnswered(questionnaireDto);
            QuestionnaireResponseEntity questionnaireResponse = this.createQuestionnaireResponse(questionnaireDto, checklistResponse);
            for (AnswerSubmissionDTO answerDto : questionnaireDto.getAnswers()) {
                this.createAnswer(answerDto, questionnaireResponse);
                if (!this.pvAnswerValidator.isPVAnswer(answerDto)) continue;
                this.createAnomalyFromPVAnswer(answerDto, submissionDto.getUserId(), submissionDto.getDamId(), questionnaireDto.getTemplateQuestionnaireId());
            }
        }
        return checklistResponse;
    }

    private void validateUserAccessToDam(Long userId, Long damId) {
        UserEntity user = (UserEntity)this.userRepository.findByIdWithClients(userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        DamEntity dam = (DamEntity)this.damRepository.findById((Object)damId).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada!"));
        if (AuthenticatedUserUtil.isAdmin()) {
            return;
        }
        boolean userBelongsToClient = user.getClients().stream().anyMatch(client -> client.getId().equals(dam.getClient().getId()));
        if (!userBelongsToClient) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para acessar esta barragem. O usu\u00e1rio n\u00e3o pertence ao cliente propriet\u00e1rio da barragem.");
        }
        boolean hasSpecificPermission = user.getDamPermissions().stream().anyMatch(permission -> permission.getDam().getId().equals(damId) && permission.getHasAccess() != false && permission.getClient().getId().equals(dam.getClient().getId()));
        if (!hasSpecificPermission) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o espec\u00edfica para acessar esta barragem. Verifique as permiss\u00f5es de acesso na administra\u00e7\u00e3o do sistema.");
        }
    }

    private void validatePVAnswersHaveRequiredFields(ChecklistResponseSubmissionDTO submissionDto) {
        for (QuestionnaireResponseSubmissionDTO questionnaireDto : submissionDto.getQuestionnaireResponses()) {
            for (AnswerSubmissionDTO answerDto : questionnaireDto.getAnswers()) {
                QuestionEntity question = (QuestionEntity)this.questionRepository.findById((Object)answerDto.getQuestionId()).orElseThrow(() -> new NotFoundException("Pergunta n\u00e3o encontrada: " + answerDto.getQuestionId()));
                this.pvAnswerValidator.validatePVAnswer(answerDto, question.getQuestionText());
            }
        }
    }

    private void createAnomalyFromPVAnswer(AnswerSubmissionDTO answerDto, Long userId, Long damId, Long questionnaireId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        DamEntity dam = (DamEntity)this.damRepository.findById((Object)damId).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada!"));
        DangerLevelEntity dangerLevel = (DangerLevelEntity)this.dangerLevelRepository.findById((Object)answerDto.getAnomalyDangerLevelId()).orElseThrow(() -> new NotFoundException("N\u00edvel de perigo n\u00e3o encontrado!"));
        AnomalyStatusEntity status = (AnomalyStatusEntity)this.anomalyStatusRepository.findById((Object)answerDto.getAnomalyStatusId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado!"));
        AnomalyEntity anomaly = new AnomalyEntity();
        anomaly.setUser(user);
        anomaly.setDam(dam);
        anomaly.setLatitude(answerDto.getLatitude());
        anomaly.setLongitude(answerDto.getLongitude());
        anomaly.setQuestionnaireId(questionnaireId);
        anomaly.setQuestionId(answerDto.getQuestionId());
        anomaly.setOrigin(AnomalyOriginEnum.CHECKLIST);
        anomaly.setObservation(answerDto.getComment());
        anomaly.setRecommendation(answerDto.getAnomalyRecommendation());
        anomaly.setDangerLevel(dangerLevel);
        anomaly.setStatus(status);
        AnomalyEntity savedAnomaly = (AnomalyEntity)this.anomalyRepository.save((Object)anomaly);
        if (answerDto.getPhotos() != null && !answerDto.getPhotos().isEmpty()) {
            for (PhotoSubmissionDTO photoDto : answerDto.getPhotos()) {
                this.saveAnomalyPhoto(photoDto, savedAnomaly, dam.getId());
            }
        }
    }

    private void saveAnomalyPhoto(PhotoSubmissionDTO photoDto, AnomalyEntity anomaly, Long damId) {
        try {
            String base64Image = photoDto.getBase64Image();
            if (base64Image.contains(",")) {
                base64Image = base64Image.split(",")[1];
            }
            byte[] imageBytes = Base64.getDecoder().decode(base64Image);
            String photoUrl = this.fileStorageService.storeFileFromBytes(imageBytes, photoDto.getFileName(), photoDto.getContentType(), "anomalies");
            AnomalyPhotoEntity photoEntity = new AnomalyPhotoEntity();
            photoEntity.setAnomaly(anomaly);
            photoEntity.setImagePath(photoUrl);
            photoEntity.setDamId(damId);
            this.anomalyPhotoRepository.save((Object)photoEntity);
        }
        catch (Exception e) {
            throw new FileStorageException("Erro ao processar imagem da anomalia: " + e.getMessage());
        }
    }

    private void validateAllRequiredQuestionnaires(ChecklistResponseSubmissionDTO submissionDto) {
        ChecklistEntity checklist = (ChecklistEntity)this.checklistRepository.findByNameIgnoreCase(submissionDto.getChecklistName()).orElseThrow(() -> new NotFoundException("Checklist n\u00e3o encontrado com o nome: " + submissionDto.getChecklistName()));
        Set requiredTemplates = checklist.getTemplateQuestionnaires();
        Set requiredTemplateIds = requiredTemplates.stream().map(TemplateQuestionnaireEntity::getId).collect(Collectors.toSet());
        Set submittedTemplateIds = submissionDto.getQuestionnaireResponses().stream().map(QuestionnaireResponseSubmissionDTO::getTemplateQuestionnaireId).collect(Collectors.toSet());
        if (!submittedTemplateIds.containsAll(requiredTemplateIds)) {
            HashSet missingTemplateIds = new HashSet(requiredTemplateIds);
            missingTemplateIds.removeAll(submittedTemplateIds);
            List missingTemplateNames = missingTemplateIds.stream().map(id -> {
                TemplateQuestionnaireEntity template = (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.findById(id).orElseThrow(() -> new NotFoundException("Template de question\u00e1rio n\u00e3o encontrado: " + id));
                return template.getName();
            }).collect(Collectors.toList());
            String errorMsg = String.format("Os seguintes question\u00e1rios obrigat\u00f3rios n\u00e3o foram inclu\u00eddos no checklist '%s': %s", checklist.getName(), String.join((CharSequence)", ", missingTemplateNames));
            throw new InvalidInputException(errorMsg);
        }
        if (!requiredTemplateIds.containsAll(submittedTemplateIds)) {
            HashSet extraTemplateIds = new HashSet(submittedTemplateIds);
            extraTemplateIds.removeAll(requiredTemplateIds);
            String errorMsg = String.format("Os seguintes question\u00e1rios n\u00e3o pertencem ao checklist '%s': %s", checklist.getName(), extraTemplateIds);
            throw new InvalidInputException(errorMsg);
        }
    }

    private void validateAllQuestionsAnswered(QuestionnaireResponseSubmissionDTO questionnaireDto) {
        TemplateQuestionnaireEntity template = (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.findById((Object)questionnaireDto.getTemplateQuestionnaireId()).orElseThrow(() -> new NotFoundException("Modelo de question\u00e1rio n\u00e3o encontrado: " + questionnaireDto.getTemplateQuestionnaireId()));
        Set templateQuestionIds = template.getTemplateQuestions().stream().map(tq -> tq.getQuestion().getId()).collect(Collectors.toSet());
        Set answeredQuestionIds = questionnaireDto.getAnswers().stream().map(AnswerSubmissionDTO::getQuestionId).collect(Collectors.toSet());
        if (!answeredQuestionIds.containsAll(templateQuestionIds)) {
            HashSet missingQuestionIds = new HashSet(templateQuestionIds);
            missingQuestionIds.removeAll(answeredQuestionIds);
            List missingQuestionTexts = missingQuestionIds.stream().map(id -> {
                QuestionEntity question = (QuestionEntity)this.questionRepository.findById(id).orElseThrow(() -> new NotFoundException("Pergunta n\u00e3o encontrada: " + id));
                return question.getQuestionText();
            }).collect(Collectors.toList());
            String errorMsg = String.format("As seguintes perguntas n\u00e3o foram respondidas para o question\u00e1rio '%s': %s", template.getName(), String.join((CharSequence)", ", missingQuestionTexts));
            throw new InvalidInputException(errorMsg);
        }
        if (!templateQuestionIds.containsAll(answeredQuestionIds)) {
            HashSet extraQuestionIds = new HashSet(answeredQuestionIds);
            extraQuestionIds.removeAll(templateQuestionIds);
            String errorMsg = String.format("As seguintes perguntas n\u00e3o pertencem ao question\u00e1rio '%s': %s", template.getName(), extraQuestionIds);
            throw new InvalidInputException(errorMsg);
        }
    }

    private ChecklistResponseEntity createChecklistResponse(ChecklistResponseSubmissionDTO submissionDto) {
        DamEntity dam = this.damService.findById(submissionDto.getDamId());
        UserEntity user = (UserEntity)this.userRepository.findById((Object)submissionDto.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        ChecklistResponseEntity checklistResponse = new ChecklistResponseEntity();
        checklistResponse.setChecklistName(submissionDto.getChecklistName());
        checklistResponse.setChecklistId(submissionDto.getChecklistId());
        checklistResponse.setDam(dam);
        checklistResponse.setUser(user);
        return (ChecklistResponseEntity)this.checklistResponseRepository.save((Object)checklistResponse);
    }

    private QuestionnaireResponseEntity createQuestionnaireResponse(QuestionnaireResponseSubmissionDTO questionnaireDto, ChecklistResponseEntity checklistResponse) {
        TemplateQuestionnaireEntity templateQuestionnaire = (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.findById((Object)questionnaireDto.getTemplateQuestionnaireId()).orElseThrow(() -> new NotFoundException("Modelo de question\u00e1rio n\u00e3o encontrado!"));
        QuestionnaireResponseEntity questionnaireResponse = new QuestionnaireResponseEntity();
        questionnaireResponse.setTemplateQuestionnaire(templateQuestionnaire);
        questionnaireResponse.setChecklistResponse(checklistResponse);
        questionnaireResponse.setDam(checklistResponse.getDam());
        return (QuestionnaireResponseEntity)this.questionnaireResponseRepository.save((Object)questionnaireResponse);
    }

    private AnswerEntity createAnswer(AnswerSubmissionDTO answerDto, QuestionnaireResponseEntity questionnaireResponse) {
        QuestionEntity question = (QuestionEntity)this.questionRepository.findById((Object)answerDto.getQuestionId()).orElseThrow(() -> new NotFoundException("Pergunta n\u00e3o encontrada: " + answerDto.getQuestionId()));
        AnswerEntity answer = new AnswerEntity();
        answer.setQuestion(question);
        answer.setQuestionnaireResponse(questionnaireResponse);
        answer.setLatitude(answerDto.getLatitude());
        answer.setLongitude(answerDto.getLongitude());
        if (TypeQuestionEnum.TEXT.equals((Object)question.getType())) {
            if (answerDto.getComment() == null || answerDto.getComment().trim().isEmpty()) {
                throw new InvalidInputException("A pergunta '" + question.getQuestionText() + "' \u00e9 do tipo TEXT e requer uma resposta textual!");
            }
            answer.setComment(answerDto.getComment());
        } else if (TypeQuestionEnum.CHECKBOX.equals((Object)question.getType())) {
            if (answerDto.getSelectedOptionIds() == null || answerDto.getSelectedOptionIds().isEmpty()) {
                throw new InvalidInputException("A pergunta '" + question.getQuestionText() + "' \u00e9 do tipo CHECKBOX e requer ao menos uma op\u00e7\u00e3o selecionada!");
            }
            HashSet<OptionEntity> options = new HashSet<OptionEntity>();
            for (Long optionId : answerDto.getSelectedOptionIds()) {
                OptionEntity option = (OptionEntity)this.optionRepository.findById((Object)optionId).orElseThrow(() -> new NotFoundException("Op\u00e7\u00e3o n\u00e3o encontrada: " + optionId));
                options.add(option);
            }
            answer.setSelectedOptions(options);
            answer.setComment(answerDto.getComment());
        }
        AnswerEntity savedAnswer = (AnswerEntity)this.answerRepository.save((Object)answer);
        if (answerDto.getPhotos() != null && !answerDto.getPhotos().isEmpty()) {
            for (PhotoSubmissionDTO photoDto : answerDto.getPhotos()) {
                this.saveAnswerPhoto(photoDto, savedAnswer);
            }
        }
        return savedAnswer;
    }

    private AnswerPhotoEntity saveAnswerPhoto(PhotoSubmissionDTO photoDto, AnswerEntity answer) {
        try {
            byte[] imageBytes = Base64.getDecoder().decode(photoDto.getBase64Image());
            String photoUrl = this.fileStorageService.storeFileFromBytes(imageBytes, photoDto.getFileName(), photoDto.getContentType(), "answer-photos");
            AnswerPhotoEntity photo = new AnswerPhotoEntity();
            photo.setAnswer(answer);
            photo.setImagePath(photoUrl);
            return (AnswerPhotoEntity)this.answerPhotoRepository.save((Object)photo);
        }
        catch (Exception e) {
            throw new FileStorageException("Erro ao processar imagem: " + e.getMessage());
        }
    }

    @Generated
    public ChecklistResponseSubmissionService(ChecklistResponseRepository checklistResponseRepository, QuestionnaireResponseRepository questionnaireResponseRepository, AnswerRepository answerRepository, AnswerPhotoRepository answerPhotoRepository, OptionRepository optionRepository, QuestionRepository questionRepository, TemplateQuestionnaireRepository templateQuestionnaireRepository, FileStorageService fileStorageService, DamService damService, UserRepository userRepository, ChecklistRepository checklistRepository, DangerLevelRepository dangerLevelRepository, AnomalyStatusRepository anomalyStatusRepository, AnomalyRepository anomalyRepository, PVAnswerValidator pvAnswerValidator, DamRepository damRepository, AnomalyPhotoRepository anomalyPhotoRepository) {
        this.checklistResponseRepository = checklistResponseRepository;
        this.questionnaireResponseRepository = questionnaireResponseRepository;
        this.answerRepository = answerRepository;
        this.answerPhotoRepository = answerPhotoRepository;
        this.optionRepository = optionRepository;
        this.questionRepository = questionRepository;
        this.templateQuestionnaireRepository = templateQuestionnaireRepository;
        this.fileStorageService = fileStorageService;
        this.damService = damService;
        this.userRepository = userRepository;
        this.checklistRepository = checklistRepository;
        this.dangerLevelRepository = dangerLevelRepository;
        this.anomalyStatusRepository = anomalyStatusRepository;
        this.anomalyRepository = anomalyRepository;
        this.pvAnswerValidator = pvAnswerValidator;
        this.damRepository = damRepository;
        this.anomalyPhotoRepository = anomalyPhotoRepository;
    }
}

