/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.answer.persistence.jpa;

import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.infra.answer.persistence.jpa.AnswerRepositoryCustom;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AnswerRepository
extends JpaRepository<AnswerEntity, Long>,
AnswerRepositoryCustom {
    @EntityGraph(attributePaths={"question", "selectedOptions", "photos", "questionnaireResponse"})
    @Query(value="SELECT a FROM AnswerEntity a WHERE a.id = :id")
    public Optional<AnswerEntity> findByIdWithAllDetails(@Param(value="id") Long var1);

    @EntityGraph(attributePaths={"question", "selectedOptions", "photos"})
    @Query(value="SELECT a FROM AnswerEntity a WHERE a.questionnaireResponse.id = :questionnaireResponseId")
    public List<AnswerEntity> findByQuestionnaireResponseIdWithDetails(@Param(value="questionnaireResponseId") Long var1);

    @EntityGraph(attributePaths={"selectedOptions", "photos", "questionnaireResponse"})
    @Query(value="SELECT a FROM AnswerEntity a WHERE a.question.id = :questionId")
    public List<AnswerEntity> findByQuestionIdWithDetails(@Param(value="questionId") Long var1);

    @Query(value="SELECT a FROM AnswerEntity a JOIN a.selectedOptions o WHERE a.questionnaireResponse.dam.id = :damId AND a.question.id = :questionId AND LOWER(o.label) != 'ni' ORDER BY a.questionnaireResponse.createdAt DESC")
    @EntityGraph(attributePaths={"selectedOptions", "question", "questionnaireResponse"})
    public List<AnswerEntity> findNonNIAnswersByDamAndQuestion(@Param(value="damId") Long var1, @Param(value="questionId") Long var2);

    @Query(value="SELECT a FROM AnswerEntity a JOIN a.selectedOptions o WHERE a.questionnaireResponse.dam.id = :damId AND a.question.id = :questionId AND a.questionnaireResponse.templateQuestionnaire.id = :templateId AND LOWER(o.label) != 'ni' AND a.questionnaireResponse.createdAt = (    SELECT MAX(qr.createdAt) FROM QuestionnaireResponseEntity qr     JOIN qr.answers a2     JOIN a2.selectedOptions o2     WHERE qr.dam.id = :damId     AND a2.question.id = :questionId     AND qr.templateQuestionnaire.id = :templateId     AND LOWER(o2.label) != 'ni')")
    @EntityGraph(attributePaths={"selectedOptions", "question", "questionnaireResponse"})
    public Optional<AnswerEntity> findLatestNonNIAnswer(@Param(value="damId") Long var1, @Param(value="questionId") Long var2, @Param(value="templateId") Long var3);
}

