/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.anomaly_status.services;

import com.geosegbar.entities.AnomalyStatusEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.anomaly_status.persistence.jpa.AnomalyStatusRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AnomalyStatusService {
    private final AnomalyStatusRepository anomalyStatusRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultStatus() {
        this.createIfNotExists("Pendente", "Anomalia identificada, aguardando an\u00e1lise");
        this.createIfNotExists("Em andamento", "Anomalia em processo de tratamento");
        this.createIfNotExists("Conclu\u00eddo", "Tratamento da anomalia finalizado");
        this.createIfNotExists("Em monitoramento", "Anomalia tratada mas sob observa\u00e7\u00e3o");
        this.createIfNotExists("--", "Ainda n\u00e3o foi definido um status para a anomalia");
    }

    private void createIfNotExists(String name, String description) {
        Optional existingStatus = this.anomalyStatusRepository.findByName(name);
        if (existingStatus.isEmpty()) {
            AnomalyStatusEntity status = new AnomalyStatusEntity();
            status.setName(name);
            status.setDescription(description);
            this.anomalyStatusRepository.save((Object)status);
        }
    }

    public List<AnomalyStatusEntity> findAll() {
        return this.anomalyStatusRepository.findAll();
    }

    public AnomalyStatusEntity findById(Long id) {
        return (AnomalyStatusEntity)this.anomalyStatusRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Anomaly status not found!"));
    }

    public AnomalyStatusEntity findByName(String name) {
        return (AnomalyStatusEntity)this.anomalyStatusRepository.findByName(name).orElseThrow(() -> new NotFoundException("Anomaly status not found with name: " + name));
    }

    @Generated
    public AnomalyStatusService(AnomalyStatusRepository anomalyStatusRepository) {
        this.anomalyStatusRepository = anomalyStatusRepository;
    }
}

