/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.statistical_limit.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.StatisticalLimitEntity;
import com.geosegbar.infra.statistical_limit.services.StatisticalLimitService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/statistical-limits"})
public class StatisticalLimitController {
    private final StatisticalLimitService statisticalLimitService;

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<StatisticalLimitEntity>> getById(@PathVariable Long id) {
        StatisticalLimitEntity limit = this.statisticalLimitService.findById(id);
        return ResponseEntity.ok(WebResponseEntity.success(limit, "Limite estat\u00edstico obtido com sucesso!"));
    }

    @PostMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<StatisticalLimitEntity>> create(@PathVariable Long instrumentId, @Valid @RequestBody StatisticalLimitEntity limit) {
        StatisticalLimitEntity created = this.statisticalLimitService.createOrUpdate(instrumentId, limit);
        return new ResponseEntity(WebResponseEntity.success(created, "Limite estat\u00edstico criado com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<StatisticalLimitEntity>> update(@PathVariable Long instrumentId, @Valid @RequestBody StatisticalLimitEntity limit) {
        StatisticalLimitEntity updated = this.statisticalLimitService.createOrUpdate(instrumentId, limit);
        return ResponseEntity.ok(WebResponseEntity.success(updated, "Limite estat\u00edstico atualizado com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> delete(@PathVariable Long id) {
        this.statisticalLimitService.deleteById(id);
        return ResponseEntity.ok(WebResponseEntity.success(null, "Limite estat\u00edstico exclu\u00eddo com sucesso!"));
    }

    @Generated
    public StatisticalLimitController(StatisticalLimitService statisticalLimitService) {
        this.statisticalLimitService = statisticalLimitService;
    }
}

