/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.level.services;

import com.geosegbar.entities.LevelEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.level.persistence.LevelRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LevelService {
    private final LevelRepository levelRepository;

    public List<LevelEntity> findAll() {
        return this.levelRepository.findAllByOrderByIdAsc();
    }

    public LevelEntity findById(Long id) {
        return (LevelEntity)this.levelRepository.findById(id).orElseThrow(() -> new NotFoundException("N\u00edvel n\u00e3o encontrado!"));
    }

    @Transactional
    public LevelEntity save(LevelEntity level) {
        if (this.levelRepository.existsByName(level.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe um n\u00edvel com este nome!");
        }
        return (LevelEntity)this.levelRepository.save(level);
    }

    @Transactional
    public LevelEntity update(LevelEntity level) {
        this.levelRepository.findById(level.getId()).orElseThrow(() -> new NotFoundException("N\u00edvel n\u00e3o encontrado para atualiza\u00e7\u00e3o!"));
        if (this.levelRepository.existsByNameAndIdNot(level.getName(), level.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um n\u00edvel com este nome!");
        }
        return (LevelEntity)this.levelRepository.save(level);
    }

    @Transactional
    public void deleteById(Long id) {
        this.levelRepository.findById(id).orElseThrow(() -> new NotFoundException("N\u00edvel n\u00e3o encontrado para exclus\u00e3o!"));
        this.levelRepository.deleteById(id);
    }

    @Generated
    public LevelService(LevelRepository levelRepository) {
        this.levelRepository = levelRepository;
    }
}

