/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_axes.services;

import com.geosegbar.entities.InstrumentGraphAxesEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.instrument_graph_axes.dtos.GraphAxesResponseDTO;
import com.geosegbar.infra.instrument_graph_axes.dtos.UpdateGraphAxesRequestDTO;
import com.geosegbar.infra.instrument_graph_axes.persistence.jpa.InstrumentGraphAxesRepository;
import com.geosegbar.infra.instrument_graph_pattern.services.InstrumentGraphPatternService;
import lombok.Generated;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentGraphAxesService {
    private final InstrumentGraphAxesRepository axesRepository;
    private final InstrumentGraphPatternService patternService;

    @Transactional
    @CacheEvict(value={"graphAxes", "graphPatternById", "graphPatternsByInstrument", "graphPatternsByDam", "folderWithPatterns", "damFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public GraphAxesResponseDTO updateAxes(Long patternId, UpdateGraphAxesRequestDTO req) {
        this.patternService.findById(patternId);
        InstrumentGraphAxesEntity axes = this.findByPatternId(patternId);
        axes.setAbscissaPx(req.getAbscissaPx());
        axes.setAbscissaGridLinesEnable(req.getAbscissaGridLinesEnable());
        axes.setPrimaryOrdinatePx(req.getPrimaryOrdinatePx());
        axes.setSecondaryOrdinatePx(req.getSecondaryOrdinatePx());
        axes.setPrimaryOrdinateGridLinesEnable(req.getPrimaryOrdinateGridLinesEnable());
        axes.setPrimaryOrdinateTitle(req.getPrimaryOrdinateTitle());
        axes.setSecondaryOrdinateTitle(req.getSecondaryOrdinateTitle());
        axes.setPrimaryOrdinateSpacing(req.getPrimaryOrdinateSpacing());
        axes.setSecondaryOrdinateSpacing(req.getSecondaryOrdinateSpacing());
        axes.setPrimaryOrdinateInitialValue(req.getPrimaryOrdinateInitialValue());
        axes.setSecondaryOrdinateInitialValue(req.getSecondaryOrdinateInitialValue());
        axes.setPrimaryOrdinateMaximumValue(req.getPrimaryOrdinateMaximumValue());
        axes.setSecondaryOrdinateMaximumValue(req.getSecondaryOrdinateMaximumValue());
        InstrumentGraphAxesEntity saved = (InstrumentGraphAxesEntity)this.axesRepository.save(axes);
        return this.mapToResponseDTO(saved);
    }

    @Cacheable(value={"graphAxes"}, key="#patternId", cacheManager="instrumentGraphCacheManager")
    public InstrumentGraphAxesEntity findByPatternId(Long patternId) {
        return this.axesRepository.findByPatternId(patternId).orElseThrow(() -> new NotFoundException("Eixos n\u00e3o encontrados para o padr\u00e3o ID: " + patternId));
    }

    public GraphAxesResponseDTO mapToResponseDTO(InstrumentGraphAxesEntity axes) {
        return new GraphAxesResponseDTO(axes.getId(), axes.getPattern().getId(), axes.getAbscissaPx(), axes.getAbscissaGridLinesEnable(), axes.getPrimaryOrdinatePx(), axes.getSecondaryOrdinatePx(), axes.getPrimaryOrdinateGridLinesEnable(), axes.getPrimaryOrdinateTitle(), axes.getSecondaryOrdinateTitle(), axes.getPrimaryOrdinateSpacing(), axes.getSecondaryOrdinateSpacing(), axes.getPrimaryOrdinateInitialValue(), axes.getSecondaryOrdinateInitialValue(), axes.getPrimaryOrdinateMaximumValue(), axes.getSecondaryOrdinateMaximumValue());
    }

    @Generated
    public InstrumentGraphAxesService(InstrumentGraphAxesRepository axesRepository, InstrumentGraphPatternService patternService) {
        this.axesRepository = axesRepository;
        this.patternService = patternService;
    }
}

