/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument.services;

import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.infra.instrument_graph_pattern.dtos.CreateGraphPatternRequest;
import com.geosegbar.infra.instrument_graph_pattern.services.InstrumentGraphPatternService;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.CreateTabulatePatternRequestDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.services.InstrumentTabulatePatternService;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AutoPatternCreationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoPatternCreationService.class);
    private final InstrumentGraphPatternService graphPatternService;
    private final InstrumentTabulatePatternService tabulatePatternService;

    @Async
    @Transactional
    public void createPatternsForInstrument(InstrumentEntity instrument) {
        if (Boolean.TRUE.equals(instrument.getIsLinimetricRuler())) {
            log.debug("Ignorando cria\u00e7\u00e3o de padr\u00f5es para r\u00e9gua linim\u00e9trica: {}", (Object)instrument.getId());
            return;
        }
        try {
            this.createGraphPatternForInstrument(instrument);
            this.createTabulatePatternForInstrument(instrument);
            log.info("Padr\u00f5es de gr\u00e1fico e tabela criados com sucesso para o instrumento: {}", (Object)instrument.getId());
        }
        catch (Exception e) {
            log.error("Erro ao criar padr\u00f5es autom\u00e1ticos para o instrumento {}: {}", new Object[]{instrument.getId(), e.getMessage(), e});
        }
    }

    private void createGraphPatternForInstrument(InstrumentEntity instrument) {
        String patternName = "Padr\u00e3o Autom\u00e1tico - " + instrument.getName();
        CreateGraphPatternRequest request = new CreateGraphPatternRequest();
        request.setInstrumentId(instrument.getId());
        request.setName(patternName);
        request.setFolderId(null);
        try {
            this.graphPatternService.create(request);
            log.debug("Padr\u00e3o de gr\u00e1fico criado para o instrumento: {}", (Object)instrument.getId());
        }
        catch (Exception e) {
            log.error("Erro ao criar padr\u00e3o de gr\u00e1fico para o instrumento {}: {}", new Object[]{instrument.getId(), e.getMessage(), e});
        }
    }

    private void createTabulatePatternForInstrument(InstrumentEntity instrument) {
        String patternName = "Padr\u00e3o Autom\u00e1tico - " + instrument.getName();
        CreateTabulatePatternRequestDTO request = new CreateTabulatePatternRequestDTO();
        request.setName(patternName);
        request.setDamId(instrument.getDam().getId());
        request.setFolderId(null);
        ArrayList<CreateTabulatePatternRequestDTO.InstrumentAssociationDTO> associations = new ArrayList<CreateTabulatePatternRequestDTO.InstrumentAssociationDTO>();
        CreateTabulatePatternRequestDTO.InstrumentAssociationDTO association = new CreateTabulatePatternRequestDTO.InstrumentAssociationDTO();
        association.setInstrumentId(instrument.getId());
        association.setIsDateEnable(true);
        association.setDateIndex(1);
        association.setIsHourEnable(true);
        association.setHourIndex(2);
        association.setIsUserEnable(true);
        association.setUserIndex(3);
        association.setIsReadEnable(true);
        ArrayList<CreateTabulatePatternRequestDTO.OutputAssociationDTO> outputAssociations = new ArrayList<CreateTabulatePatternRequestDTO.OutputAssociationDTO>();
        int index = 4;
        for (OutputEntity output : instrument.getOutputs()) {
            if (!Boolean.TRUE.equals(output.getActive())) continue;
            CreateTabulatePatternRequestDTO.OutputAssociationDTO outputAssoc = new CreateTabulatePatternRequestDTO.OutputAssociationDTO();
            outputAssoc.setOutputId(output.getId());
            outputAssoc.setOutputIndex(index++);
            outputAssociations.add(outputAssoc);
        }
        if (outputAssociations.isEmpty()) {
            log.warn("N\u00e3o foi poss\u00edvel criar padr\u00e3o de tabela para o instrumento {} porque n\u00e3o h\u00e1 outputs ativos", (Object)instrument.getId());
            return;
        }
        association.setOutputAssociations(outputAssociations);
        associations.add(association);
        request.setAssociations(associations);
        try {
            this.tabulatePatternService.create(request);
            log.debug("Padr\u00e3o de tabela criado para o instrumento: {}", (Object)instrument.getId());
        }
        catch (Exception e) {
            log.error("Erro ao criar padr\u00e3o de tabela para o instrumento {}: {}", new Object[]{instrument.getId(), e.getMessage(), e});
        }
    }

    @Generated
    public AutoPatternCreationService(InstrumentGraphPatternService graphPatternService, InstrumentTabulatePatternService tabulatePatternService) {
        this.graphPatternService = graphPatternService;
        this.tabulatePatternService = tabulatePatternService;
    }
}

