/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist_submission.services;

import com.geosegbar.entities.OptionEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.checklist_submission.dtos.AnswerSubmissionDTO;
import com.geosegbar.infra.option.persistence.jpa.OptionRepository;
import java.util.ArrayList;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class PVAnswerValidator {
    private final OptionRepository optionRepository;

    public void validatePVAnswer(AnswerSubmissionDTO answerDto, String questionText) {
        boolean isPVAnswer = false;
        if (answerDto.getSelectedOptionIds() != null && !answerDto.getSelectedOptionIds().isEmpty()) {
            for (Long optionId : answerDto.getSelectedOptionIds()) {
                OptionEntity option = (OptionEntity)this.optionRepository.findById(optionId).orElseThrow(() -> new NotFoundException("Op\u00e7\u00e3o n\u00e3o encontrada: " + optionId));
                if (!"PV".equals(option.getLabel())) continue;
                isPVAnswer = true;
                break;
            }
        }
        if (isPVAnswer) {
            ArrayList<String> missingFields = new ArrayList<String>();
            if (answerDto.getAnomalyRecommendation() == null || answerDto.getAnomalyRecommendation().trim().isEmpty()) {
                missingFields.add("recommendation");
            }
            if (answerDto.getAnomalyDangerLevelId() == null) {
                missingFields.add("dangerLevelId");
            }
            if (answerDto.getAnomalyStatusId() == null) {
                missingFields.add("statusId");
            }
            if (answerDto.getPhotos() == null || answerDto.getPhotos().isEmpty()) {
                missingFields.add("photo");
            }
            if (answerDto.getLatitude() == null || answerDto.getLongitude() == null) {
                missingFields.add("latitude/longitude");
            }
            if (!missingFields.isEmpty()) {
                throw new InvalidInputException("A pergunta '" + questionText + "' foi marcada como PV, mas faltam os seguintes campos obrigat\u00f3rios para criar a anomalia: " + String.join((CharSequence)", ", missingFields));
            }
        }
    }

    public boolean isPVAnswer(AnswerSubmissionDTO answerDto) {
        if (answerDto.getSelectedOptionIds() != null && !answerDto.getSelectedOptionIds().isEmpty()) {
            for (Long optionId : answerDto.getSelectedOptionIds()) {
                OptionEntity option = (OptionEntity)this.optionRepository.findById(optionId).orElseThrow(() -> new NotFoundException("Op\u00e7\u00e3o n\u00e3o encontrada: " + optionId));
                if (!"PV".equals(option.getLabel())) continue;
                return true;
            }
        }
        return false;
    }

    @Generated
    public PVAnswerValidator(OptionRepository optionRepository) {
        this.optionRepository = optionRepository;
    }
}

