/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.common.enums.FolderColorEnum;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.PSBFileEntity;
import com.geosegbar.entities.ShareFolderEntity;
import com.geosegbar.entities.UserEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@Table(name="psb_folders", indexes={@Index(name="idx_psb_folder_dam_id", columnList="dam_id"), @Index(name="idx_psb_folder_created_by", columnList="created_by"), @Index(name="idx_psb_folder_dam_idx", columnList="dam_id, folder_index"), @Index(name="idx_psb_folder_dam_name", columnList="dam_id, name"), @Index(name="idx_psb_folder_updated_at", columnList="updated_at")})
public class PSBFolderEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="O nome da pasta \u00e9 obrigat\u00f3rio")
    @Column(nullable=false)
    private @NotBlank(message="O nome da pasta \u00e9 obrigat\u00f3rio") String name;
    @NotNull(message="O \u00edndice da pasta \u00e9 obrigat\u00f3rio")
    @Column(name="folder_index", nullable=false)
    private @NotNull(message="O \u00edndice da pasta \u00e9 obrigat\u00f3rio") Integer folderIndex;
    @Column(nullable=true, length=1000)
    private String description;
    @Column(name="server_path", nullable=false)
    private String serverPath;
    @Enumerated(value=EnumType.STRING)
    @Column(name="color", nullable=true)
    private FolderColorEnum color = FolderColorEnum.BLUE;
    @ManyToOne
    @JoinColumn(name="dam_id", nullable=false)
    @JsonIgnoreProperties(value={"psbFolders", "reservoirs", "regulatoryDam", "documentationDam", "checklists", "checklistResponses", "damPermissions"})
    private DamEntity dam;
    @OneToMany(mappedBy="psbFolder", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"psbFolder"})
    private Set<PSBFileEntity> files = new HashSet<PSBFileEntity>();
    @Column(name="created_at")
    private LocalDateTime createdAt;
    @Column(name="updated_at")
    private LocalDateTime updatedAt;
    @ManyToOne
    @JoinColumn(name="created_by")
    @JsonIgnoreProperties(value={"psbFoldersCreated", "psbFilesUploaded"})
    private UserEntity createdBy;
    @OneToMany(mappedBy="psbFolder", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"psbFolder"})
    private Set<ShareFolderEntity> shareLinks = new HashSet<ShareFolderEntity>();

    @PrePersist
    protected void onCreate() {
        this.createdAt = LocalDateTime.now();
        this.updatedAt = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getFolderIndex() {
        return this.folderIndex;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getServerPath() {
        return this.serverPath;
    }

    @Generated
    public FolderColorEnum getColor() {
        return this.color;
    }

    @Generated
    public DamEntity getDam() {
        return this.dam;
    }

    @Generated
    public Set<PSBFileEntity> getFiles() {
        return this.files;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public UserEntity getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Set<ShareFolderEntity> getShareLinks() {
        return this.shareLinks;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setFolderIndex(Integer folderIndex) {
        this.folderIndex = folderIndex;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    @Generated
    public void setColor(FolderColorEnum color) {
        this.color = color;
    }

    @JsonIgnoreProperties(value={"psbFolders", "reservoirs", "regulatoryDam", "documentationDam", "checklists", "checklistResponses", "damPermissions"})
    @Generated
    public void setDam(DamEntity dam) {
        this.dam = dam;
    }

    @JsonIgnoreProperties(value={"psbFolder"})
    @Generated
    public void setFiles(Set<PSBFileEntity> files) {
        this.files = files;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonIgnoreProperties(value={"psbFoldersCreated", "psbFilesUploaded"})
    @Generated
    public void setCreatedBy(UserEntity createdBy) {
        this.createdBy = createdBy;
    }

    @JsonIgnoreProperties(value={"psbFolder"})
    @Generated
    public void setShareLinks(Set<ShareFolderEntity> shareLinks) {
        this.shareLinks = shareLinks;
    }

    @Generated
    public PSBFolderEntity() {
    }

    @Generated
    public PSBFolderEntity(Long id, String name, Integer folderIndex, String description, String serverPath, FolderColorEnum color, DamEntity dam, Set<PSBFileEntity> files, LocalDateTime createdAt, LocalDateTime updatedAt, UserEntity createdBy, Set<ShareFolderEntity> shareLinks) {
        this.id = id;
        this.name = name;
        this.folderIndex = folderIndex;
        this.description = description;
        this.serverPath = serverPath;
        this.color = color;
        this.dam = dam;
        this.files = files;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.createdBy = createdBy;
        this.shareLinks = shareLinks;
    }
}

