/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.MeasurementUnitEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table(name="constant", indexes={@Index(name="idx_constant_instrument_id", columnList="instrument_id"), @Index(name="idx_constant_acronym", columnList="acronym"), @Index(name="idx_constant_instrument_acronym", columnList="instrument_id, acronym")})
public class ConstantEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Sigla \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="Sigla \u00e9 obrigat\u00f3rio!") String acronym;
    @NotBlank(message="Nome da Constante \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="Nome da Constante \u00e9 obrigat\u00f3rio!") String name;
    @NotNull(message="Precis\u00e3o da Constante \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotNull(message="Precis\u00e3o da Constante \u00e9 obrigat\u00f3rio!") Integer precision;
    @NotNull(message="Valor da Constante \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotNull(message="Valor da Constante \u00e9 obrigat\u00f3rio!") Double value;
    @ManyToOne
    @JoinColumn(name="measurement_unit_id", nullable=false)
    private MeasurementUnitEntity measurementUnit;
    @ManyToOne
    @JoinColumn(name="instrument_id", nullable=false)
    @JsonIgnoreProperties(value={"constants"})
    private InstrumentEntity instrument;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getAcronym() {
        return this.acronym;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPrecision() {
        return this.precision;
    }

    @Generated
    public Double getValue() {
        return this.value;
    }

    @Generated
    public MeasurementUnitEntity getMeasurementUnit() {
        return this.measurementUnit;
    }

    @Generated
    public InstrumentEntity getInstrument() {
        return this.instrument;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Generated
    public void setValue(Double value) {
        this.value = value;
    }

    @Generated
    public void setMeasurementUnit(MeasurementUnitEntity measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    @JsonIgnoreProperties(value={"constants"})
    @Generated
    public void setInstrument(InstrumentEntity instrument) {
        this.instrument = instrument;
    }

    @Generated
    public ConstantEntity() {
    }

    @Generated
    public ConstantEntity(Long id, String acronym, String name, Integer precision, Double value, MeasurementUnitEntity measurementUnit, InstrumentEntity instrument) {
        this.id = id;
        this.acronym = acronym;
        this.name = name;
        this.precision = precision;
        this.value = value;
        this.measurementUnit = measurementUnit;
        this.instrument = instrument;
    }
}

