/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.reservoir.services;

import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.LevelEntity;
import com.geosegbar.entities.ReservoirEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.level.persistence.LevelRepository;
import com.geosegbar.infra.reservoir.persistence.ReservoirRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReservoirService {
    private final ReservoirRepository reservoirRepository;
    private final DamRepository damRepository;
    private final LevelRepository levelRepository;

    public List<ReservoirEntity> findByDamId(Long damId) {
        return this.reservoirRepository.findByDamIdOrderByCreatedAtDesc(damId);
    }

    public ReservoirEntity findById(Long id) {
        return (ReservoirEntity)this.reservoirRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Reservat\u00f3rio n\u00e3o encontrado!"));
    }

    @Transactional
    public ReservoirEntity save(ReservoirEntity reservoir, Long damId, Long levelId) {
        DamEntity dam = (DamEntity)this.damRepository.findById((Object)damId).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada!"));
        LevelEntity level = (LevelEntity)this.levelRepository.findById((Object)levelId).orElseThrow(() -> new NotFoundException("N\u00edvel n\u00e3o encontrado!"));
        reservoir.setDam(dam);
        reservoir.setLevel(level);
        return (ReservoirEntity)this.reservoirRepository.save((Object)reservoir);
    }

    @Transactional
    public ReservoirEntity update(ReservoirEntity reservoir, Long id, Long levelId) {
        ReservoirEntity existingReservoir = (ReservoirEntity)this.reservoirRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Reservat\u00f3rio n\u00e3o encontrado para atualiza\u00e7\u00e3o!"));
        LevelEntity level = (LevelEntity)this.levelRepository.findById((Object)levelId).orElseThrow(() -> new NotFoundException("N\u00edvel n\u00e3o encontrado!"));
        existingReservoir.setLevel(level);
        return (ReservoirEntity)this.reservoirRepository.save((Object)existingReservoir);
    }

    @Transactional
    public void deleteById(Long id) {
        this.reservoirRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Reservat\u00f3rio n\u00e3o encontrado para exclus\u00e3o!"));
        this.reservoirRepository.deleteById((Object)id);
    }

    @Generated
    public ReservoirService(ReservoirRepository reservoirRepository, DamRepository damRepository, LevelRepository levelRepository) {
        this.reservoirRepository = reservoirRepository;
        this.damRepository = damRepository;
        this.levelRepository = levelRepository;
    }
}

