/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.questionnaire_response.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.QuestionnaireResponseEntity;
import com.geosegbar.infra.questionnaire_response.services.QuestionnaireResponseService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/questionnaire-responses"})
public class QuestionnaireResponseController {
    private final QuestionnaireResponseService questionnaireResponseService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<QuestionnaireResponseEntity>>> getAllResponses() {
        List responses = this.questionnaireResponseService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas do question\u00e1rio obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<QuestionnaireResponseEntity>> getResponseById(@PathVariable Long id) {
        QuestionnaireResponseEntity entity = this.questionnaireResponseService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)entity, (String)"Resposta do question\u00e1rio obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<QuestionnaireResponseEntity>> createResponse(@Valid @RequestBody QuestionnaireResponseEntity entity) {
        QuestionnaireResponseEntity created = this.questionnaireResponseService.save(entity);
        WebResponseEntity response = WebResponseEntity.success((Object)created, (String)"Resposta do question\u00e1rio criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<QuestionnaireResponseEntity>> updateResponse(@PathVariable Long id, @Valid @RequestBody QuestionnaireResponseEntity entity) {
        entity.setId(id);
        QuestionnaireResponseEntity updated = this.questionnaireResponseService.update(entity);
        WebResponseEntity response = WebResponseEntity.success((Object)updated, (String)"Resposta do question\u00e1rio atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteResponse(@PathVariable Long id) {
        this.questionnaireResponseService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Resposta do question\u00e1rio exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public QuestionnaireResponseController(QuestionnaireResponseService questionnaireResponseService) {
        this.questionnaireResponseService = questionnaireResponseService;
    }
}

