/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.psb.services;

import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.entities.PSBFileEntity;
import com.geosegbar.entities.PSBFolderEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.FileStorageException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.psb.persistence.PSBFileRepository;
import com.geosegbar.infra.psb.persistence.PSBFolderRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PSBFileService {
    @Value(value="${file.base-url}")
    private String baseUrl;
    private final PSBFileRepository psbFileRepository;
    private final PSBFolderRepository psbFolderRepository;
    private final UserRepository userRepository;

    public List<PSBFileEntity> findByFolderId(Long folderId) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getViewPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para acessar as pastas PSB");
        }
        return this.psbFileRepository.findByPsbFolderIdOrderByUploadedAtDesc(folderId);
    }

    public PSBFileEntity findById(Long id) {
        return (PSBFileEntity)this.psbFileRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Arquivo PSB n\u00e3o encontrado"));
    }

    @Transactional
    public PSBFileEntity uploadFile(Long folderId, MultipartFile file, Long uploadedById) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getEditPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para enviar arquivos PSB");
        }
        try {
            PSBFolderEntity folder = (PSBFolderEntity)this.psbFolderRepository.findById((Object)folderId).orElseThrow(() -> new NotFoundException("Pasta PSB n\u00e3o encontrada"));
            UserEntity uploader = (UserEntity)this.userRepository.findById((Object)uploadedById).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado"));
            String originalFilename = file.getOriginalFilename();
            String fileExtension = "";
            if (originalFilename != null && originalFilename.contains(".")) {
                fileExtension = originalFilename.substring(originalFilename.lastIndexOf("."));
            }
            String filename = UUID.randomUUID().toString() + fileExtension;
            Path folderPath = Paths.get(folder.getServerPath(), new String[0]);
            Path targetPath = folderPath.resolve(filename);
            if (!Files.exists(folderPath, new LinkOption[0])) {
                Files.createDirectories(folderPath, new FileAttribute[0]);
            }
            Files.copy(file.getInputStream(), targetPath, StandardCopyOption.REPLACE_EXISTING);
            String relativePathFromPsbBase = "dam-" + folder.getDam().getId() + "/" + folder.getServerPath().substring(folder.getServerPath().lastIndexOf(File.separator) + 1) + "/" + filename;
            String downloadUrl = this.baseUrl + "psb/" + relativePathFromPsbBase;
            PSBFileEntity psbFile = new PSBFileEntity();
            psbFile.setFilename(filename);
            psbFile.setOriginalFilename(originalFilename);
            psbFile.setContentType(file.getContentType());
            psbFile.setSize(Long.valueOf(file.getSize()));
            psbFile.setPsbFolder(folder);
            psbFile.setUploadedBy(uploader);
            psbFile.setFilePath(targetPath.toString());
            psbFile.setDownloadUrl(downloadUrl);
            return (PSBFileEntity)this.psbFileRepository.save((Object)psbFile);
        }
        catch (IOException ex) {
            throw new FileStorageException("N\u00e3o foi poss\u00edvel armazenar o arquivo.", (Throwable)ex);
        }
    }

    public Resource downloadFile(Long fileId) {
        try {
            PSBFileEntity file = (PSBFileEntity)this.psbFileRepository.findById((Object)fileId).orElseThrow(() -> new NotFoundException("Arquivo PSB n\u00e3o encontrado"));
            Path filePath = Paths.get(file.getFilePath(), new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new FileStorageException("N\u00e3o foi poss\u00edvel ler o arquivo");
        }
        catch (IOException ex) {
            throw new FileStorageException("N\u00e3o foi poss\u00edvel ler o arquivo", (Throwable)ex);
        }
    }

    @Transactional
    public void deleteFile(Long fileId) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getEditPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para excluir arquivos PSB");
        }
        PSBFileEntity file = (PSBFileEntity)this.psbFileRepository.findById((Object)fileId).orElseThrow(() -> new NotFoundException("Arquivo PSB n\u00e3o encontrado"));
        try {
            Path filePath = Paths.get(file.getFilePath(), new String[0]);
            Files.deleteIfExists(filePath);
        }
        catch (IOException ex) {
            System.err.println("Erro ao excluir arquivo do sistema: " + ex.getMessage());
        }
        this.psbFileRepository.delete((Object)file);
    }

    @Generated
    public PSBFileService(PSBFileRepository psbFileRepository, PSBFolderRepository psbFolderRepository, UserRepository userRepository) {
        this.psbFileRepository = psbFileRepository;
        this.psbFolderRepository = psbFolderRepository;
        this.userRepository = userRepository;
    }
}

