/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.output.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.infra.output.services.OutputService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outputs"})
public class OutputController {
    private final OutputService outputService;

    @GetMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<List<OutputEntity>>> getOutputsByInstrument(@PathVariable Long instrumentId) {
        List outputs = this.outputService.findByInstrumentId(instrumentId);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)outputs, (String)"Outputs do instrumento obtidos com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<OutputEntity>> getOutputById(@PathVariable Long id) {
        OutputEntity output = this.outputService.findById(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)output, (String)"Output obtido com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteOutput(@PathVariable Long id) {
        this.outputService.deleteById(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success(null, (String)"Output exclu\u00eddo com sucesso!"));
    }

    @Generated
    public OutputController(OutputService outputService) {
        this.outputService = outputService;
    }
}

