/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_pattern_folder.services;

import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.InstrumentGraphPatternEntity;
import com.geosegbar.entities.InstrumentGraphPatternFolder;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.instrument_graph_pattern.persistence.jpa.InstrumentGraphPatternRepository;
import com.geosegbar.infra.instrument_graph_pattern.services.InstrumentGraphPatternService;
import com.geosegbar.infra.instrument_graph_pattern_folder.dtos.CreateFolderRequestDTO;
import com.geosegbar.infra.instrument_graph_pattern_folder.dtos.DamFoldersWithPatternsDetailResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern_folder.dtos.FolderDetailResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern_folder.dtos.FolderResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern_folder.dtos.FolderWithPatternsDetailResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern_folder.dtos.UpdateFolderRequestDTO;
import com.geosegbar.infra.instrument_graph_pattern_folder.persistence.jpa.InstrumentGraphPatternFolderRepository;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentGraphPatternFolderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentGraphPatternFolderService.class);
    private final InstrumentGraphPatternFolderRepository folderRepository;
    private final InstrumentGraphPatternRepository patternRepository;
    private final DamService damService;
    private final InstrumentGraphPatternService patternService;

    @Transactional
    @CacheEvict(value={"folderWithPatterns", "damFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public FolderResponseDTO create(CreateFolderRequestDTO request) {
        if (this.folderRepository.existsByNameAndDamId(request.getName(), request.getDamId())) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta com o nome '" + request.getName() + "' nesta barragem!");
        }
        DamEntity dam = this.damService.findById(request.getDamId());
        InstrumentGraphPatternFolder folder = new InstrumentGraphPatternFolder();
        folder.setName(request.getName());
        folder.setDam(dam);
        folder = (InstrumentGraphPatternFolder)this.folderRepository.save((Object)folder);
        log.info("Pasta criada: id={}, name={}, damId={}", new Object[]{folder.getId(), folder.getName(), dam.getId()});
        return this.mapToResponseDTO(folder);
    }

    @Transactional
    @CacheEvict(value={"folderWithPatterns", "damFoldersWithPatterns", "graphPatternsByDam"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public FolderResponseDTO update(Long folderId, UpdateFolderRequestDTO request) {
        boolean nameExists;
        InstrumentGraphPatternFolder folder = this.findById(folderId);
        boolean bl = nameExists = this.folderRepository.existsByNameAndDamId(request.getName(), folder.getDam().getId()) && !folder.getName().equals(request.getName());
        if (nameExists) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta com o nome '" + request.getName() + "' nesta barragem!");
        }
        folder.setName(request.getName());
        if (request.getPatternIds() != null) {
            this.updatePatternAssociations(folder, request.getPatternIds());
        }
        folder = (InstrumentGraphPatternFolder)this.folderRepository.save((Object)folder);
        log.info("Pasta atualizada: id={}, newName={}, patternIds={}", new Object[]{folder.getId(), folder.getName(), request.getPatternIds()});
        return this.mapToResponseDTO(folder);
    }

    private void updatePatternAssociations(InstrumentGraphPatternFolder folder, List<Long> newPatternIds) {
        List currentPatterns = this.patternRepository.findByFolderId(folder.getId());
        Set currentPatternIds = currentPatterns.stream().map(InstrumentGraphPatternEntity::getId).collect(Collectors.toSet());
        if (newPatternIds.isEmpty()) {
            this.removeAllPatternsFromFolder(currentPatterns);
            log.info("Removidos todos {} patterns da pasta {}", (Object)currentPatterns.size(), (Object)folder.getId());
            return;
        }
        this.validatePatternsForFolder(folder, newPatternIds);
        Set newPatternIdsSet = newPatternIds.stream().collect(Collectors.toSet());
        List patternsToRemove = currentPatternIds.stream().filter(id -> !newPatternIdsSet.contains(id)).collect(Collectors.toList());
        List patternsToAdd = newPatternIdsSet.stream().filter(id -> !currentPatternIds.contains(id)).collect(Collectors.toList());
        if (!patternsToRemove.isEmpty()) {
            List patternsToRemoveEntities = this.patternRepository.findAllById(patternsToRemove);
            patternsToRemoveEntities.forEach(pattern -> pattern.setFolder(null));
            this.patternRepository.saveAll((Iterable)patternsToRemoveEntities);
            log.info("Removidos {} patterns da pasta {}: {}", new Object[]{patternsToRemove.size(), folder.getId(), patternsToRemove});
        }
        if (!patternsToAdd.isEmpty()) {
            List patternsToAddEntities = this.patternRepository.findAllById(patternsToAdd);
            patternsToAddEntities.forEach(pattern -> pattern.setFolder(folder));
            this.patternRepository.saveAll((Iterable)patternsToAddEntities);
            log.info("Adicionados {} patterns \u00e0 pasta {}: {}", new Object[]{patternsToAdd.size(), folder.getId(), patternsToAdd});
        }
    }

    private void validatePatternsForFolder(InstrumentGraphPatternFolder folder, List<Long> patternIds) {
        if (patternIds.isEmpty()) {
            return;
        }
        List patterns = this.patternRepository.findAllById(patternIds);
        if (patterns.size() != patternIds.size()) {
            Set foundIds = patterns.stream().map(InstrumentGraphPatternEntity::getId).collect(Collectors.toSet());
            List notFoundIds = patternIds.stream().filter(id -> !foundIds.contains(id)).collect(Collectors.toList());
            throw new NotFoundException("Patterns n\u00e3o encontrados: " + String.valueOf(notFoundIds));
        }
        List invalidPatterns = patterns.stream().filter(pattern -> !pattern.getInstrument().getDam().getId().equals(folder.getDam().getId())).map(InstrumentGraphPatternEntity::getId).collect(Collectors.toList());
        if (!invalidPatterns.isEmpty()) {
            throw new InvalidInputException("Os patterns " + String.valueOf(invalidPatterns) + " n\u00e3o pertencem \u00e0 mesma barragem da pasta (Dam ID: " + folder.getDam().getId() + ")");
        }
    }

    private void removeAllPatternsFromFolder(List<InstrumentGraphPatternEntity> patterns) {
        if (!patterns.isEmpty()) {
            patterns.forEach(pattern -> pattern.setFolder(null));
            this.patternRepository.saveAll(patterns);
        }
    }

    @Transactional
    @CacheEvict(value={"folderWithPatterns", "damFoldersWithPatterns", "graphPatternsByDam"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public void delete(Long folderId) {
        InstrumentGraphPatternFolder folder = this.findById(folderId);
        List patterns = this.patternRepository.findByFolderId(folderId);
        for (InstrumentGraphPatternEntity pattern : patterns) {
            pattern.setFolder(null);
        }
        if (!patterns.isEmpty()) {
            this.patternRepository.saveAll((Iterable)patterns);
            log.info("Removida refer\u00eancia da pasta de {} patterns", (Object)patterns.size());
        }
        this.folderRepository.delete((Object)folder);
        log.info("Pasta exclu\u00edda: id={}, name={}, patterns afetados={}", new Object[]{folderId, folder.getName(), patterns.size()});
    }

    public FolderDetailResponseDTO findByIdWithDetails(Long folderId) {
        InstrumentGraphPatternFolder folder = (InstrumentGraphPatternFolder)this.folderRepository.findByIdWithDam(folderId).orElseThrow(() -> new NotFoundException("Pasta n\u00e3o encontrada com ID: " + folderId));
        return this.mapToDetailResponseDTO(folder);
    }

    public FolderResponseDTO findByIdSimple(Long folderId) {
        InstrumentGraphPatternFolder folder = this.findById(folderId);
        return this.mapToResponseDTO(folder);
    }

    public InstrumentGraphPatternFolder findById(Long folderId) {
        return (InstrumentGraphPatternFolder)this.folderRepository.findById((Object)folderId).orElseThrow(() -> new NotFoundException("Pasta n\u00e3o encontrada com ID: " + folderId));
    }

    private FolderResponseDTO mapToResponseDTO(InstrumentGraphPatternFolder folder) {
        FolderResponseDTO dto = new FolderResponseDTO();
        dto.setId(folder.getId());
        dto.setName(folder.getName());
        if (folder.getDam() != null) {
            dto.setDam(new FolderResponseDTO.DamSummaryDTO(folder.getDam().getId(), folder.getDam().getName()));
        }
        return dto;
    }

    private FolderDetailResponseDTO mapToDetailResponseDTO(InstrumentGraphPatternFolder folder) {
        FolderDetailResponseDTO dto = new FolderDetailResponseDTO();
        dto.setId(folder.getId());
        dto.setName(folder.getName());
        if (folder.getDam() != null) {
            dto.setDam(new FolderDetailResponseDTO.DamDetailDTO(folder.getDam().getId(), folder.getDam().getName(), folder.getDam().getCity(), folder.getDam().getState()));
        }
        List patterns = this.patternRepository.findByFolderId(folder.getId());
        List patternDTOs = patterns.stream().map(pattern -> {
            FolderDetailResponseDTO.InstrumentSummaryDTO instrumentDTO = null;
            if (pattern.getInstrument() != null) {
                instrumentDTO = new FolderDetailResponseDTO.InstrumentSummaryDTO(pattern.getInstrument().getId(), pattern.getInstrument().getName(), pattern.getInstrument().getLocation());
            }
            return new FolderDetailResponseDTO.PatternSummaryDTO(pattern.getId(), pattern.getName(), instrumentDTO);
        }).collect(Collectors.toList());
        dto.setPatterns(patternDTOs);
        return dto;
    }

    @Cacheable(value={"folderWithPatterns"}, key="#folderId", cacheManager="instrumentGraphCacheManager")
    public FolderWithPatternsDetailResponseDTO findByIdWithPatternsDetails(Long folderId) {
        InstrumentGraphPatternFolder folder = (InstrumentGraphPatternFolder)this.folderRepository.findByIdWithDam(folderId).orElseThrow(() -> new NotFoundException("Pasta n\u00e3o encontrada com ID: " + folderId));
        List patterns = this.patternRepository.findByFolderIdWithAllDetails(folderId);
        List patternDTOs = patterns.stream().map(arg_0 -> ((InstrumentGraphPatternService)this.patternService).mapToDetailResponseDTO(arg_0)).collect(Collectors.toList());
        FolderWithPatternsDetailResponseDTO dto = new FolderWithPatternsDetailResponseDTO();
        dto.setId(folder.getId());
        dto.setName(folder.getName());
        if (folder.getDam() != null) {
            dto.setDam(new FolderWithPatternsDetailResponseDTO.DamDetailDTO(folder.getDam().getId(), folder.getDam().getName(), folder.getDam().getCity(), folder.getDam().getState()));
        }
        dto.setPatterns(patternDTOs);
        log.debug("Pasta com patterns detalhados obtida: folderId={}, patternsCount={}", (Object)folderId, (Object)patternDTOs.size());
        return dto;
    }

    @Cacheable(value={"damFoldersWithPatterns"}, key="#damId", cacheManager="instrumentGraphCacheManager")
    public DamFoldersWithPatternsDetailResponseDTO findFoldersWithPatternsDetailsByDam(Long damId) {
        DamEntity dam = this.damService.findById(damId);
        List folders = this.folderRepository.findByDamIdWithDamDetails(damId);
        List patternsInFolders = this.patternRepository.findByFolderDamIdWithAllDetails(damId);
        List patternsWithoutFolder = this.patternRepository.findByInstrumentDamIdWithoutFolderWithAllDetails(damId);
        Map<Long, List<InstrumentGraphPatternEntity>> patternsByFolder = patternsInFolders.stream().collect(Collectors.groupingBy(p -> p.getFolder().getId()));
        List folderDTOs = folders.stream().map(folder -> {
            List folderPatterns = patternsByFolder.getOrDefault(folder.getId(), List.of());
            List patternDTOs = folderPatterns.stream().map(arg_0 -> ((InstrumentGraphPatternService)this.patternService).mapToDetailResponseDTO(arg_0)).collect(Collectors.toList());
            FolderWithPatternsDetailResponseDTO folderDTO = new FolderWithPatternsDetailResponseDTO();
            folderDTO.setId(folder.getId());
            folderDTO.setName(folder.getName());
            if (folder.getDam() != null) {
                folderDTO.setDam(new FolderWithPatternsDetailResponseDTO.DamDetailDTO(folder.getDam().getId(), folder.getDam().getName(), folder.getDam().getCity(), folder.getDam().getState()));
            }
            folderDTO.setPatterns(patternDTOs);
            return folderDTO;
        }).collect(Collectors.toList());
        List patternsWithoutFolderDTOs = patternsWithoutFolder.stream().map(arg_0 -> ((InstrumentGraphPatternService)this.patternService).mapToDetailResponseDTO(arg_0)).collect(Collectors.toList());
        DamFoldersWithPatternsDetailResponseDTO responseDTO = new DamFoldersWithPatternsDetailResponseDTO();
        responseDTO.setDamId(dam.getId());
        responseDTO.setDamName(dam.getName());
        responseDTO.setDamCity(dam.getCity());
        responseDTO.setDamState(dam.getState());
        responseDTO.setFolders(folderDTOs);
        responseDTO.setPatternsWithoutFolder(patternsWithoutFolderDTOs);
        return responseDTO;
    }

    @Generated
    public InstrumentGraphPatternFolderService(InstrumentGraphPatternFolderRepository folderRepository, InstrumentGraphPatternRepository patternRepository, DamService damService, InstrumentGraphPatternService patternService) {
        this.folderRepository = folderRepository;
        this.patternRepository = patternRepository;
        this.damService = damService;
        this.patternService = patternService;
    }
}

