/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_pattern_folder.persistence.jpa;

import com.geosegbar.entities.InstrumentGraphPatternFolder;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstrumentGraphPatternFolderRepository
extends JpaRepository<InstrumentGraphPatternFolder, Long> {
    public Optional<InstrumentGraphPatternFolder> findByName(String var1);

    public boolean existsByName(String var1);

    public boolean existsByNameAndDamId(String var1, Long var2);

    public List<InstrumentGraphPatternFolder> findAllByOrderByNameAsc();

    public List<InstrumentGraphPatternFolder> findByDamId(Long var1);

    public List<InstrumentGraphPatternFolder> findByDamIdOrderByNameAsc(Long var1);

    @Query(value="SELECT f FROM InstrumentGraphPatternFolder f WHERE f.name LIKE %:name%")
    public List<InstrumentGraphPatternFolder> findByNameContaining(@Param(value="name") String var1);

    @Query(value="SELECT f FROM InstrumentGraphPatternFolder f WHERE f.dam.id = :damId AND f.name LIKE %:name%")
    public List<InstrumentGraphPatternFolder> findByDamIdAndNameContaining(@Param(value="damId") Long var1, @Param(value="name") String var2);

    @Query(value="SELECT DISTINCT f FROM InstrumentGraphPatternFolder f JOIN f.patterns p WHERE p.instrument.id = :instrumentId")
    public List<InstrumentGraphPatternFolder> findByPatternInstrumentId(@Param(value="instrumentId") Long var1);

    @Query(value="SELECT f FROM InstrumentGraphPatternFolder f LEFT JOIN FETCH f.dam d WHERE f.id = :folderId")
    public Optional<InstrumentGraphPatternFolder> findByIdWithDam(@Param(value="folderId") Long var1);

    @Query(value="SELECT f FROM InstrumentGraphPatternFolder f LEFT JOIN FETCH f.dam d WHERE f.dam.id = :damId ORDER BY f.name ASC")
    public List<InstrumentGraphPatternFolder> findByDamIdWithDamDetails(@Param(value="damId") Long var1);
}

