/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_pattern.persistence.jpa;

import com.geosegbar.entities.InstrumentGraphPatternEntity;
import jakarta.persistence.QueryHint;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstrumentGraphPatternRepository
extends JpaRepository<InstrumentGraphPatternEntity, Long> {
    public List<InstrumentGraphPatternEntity> findByInstrumentId(Long var1);

    public Optional<InstrumentGraphPatternEntity> findByNameAndInstrumentId(String var1, Long var2);

    public boolean existsByNameAndInstrumentId(String var1, Long var2);

    @Query(value="SELECT DISTINCT p FROM InstrumentGraphPatternEntity p LEFT JOIN FETCH p.instrument i LEFT JOIN FETCH p.folder f LEFT JOIN FETCH p.axes a LEFT JOIN FETCH p.properties prop LEFT JOIN FETCH prop.instrument LEFT JOIN FETCH prop.output LEFT JOIN FETCH prop.constant LEFT JOIN FETCH prop.statisticalLimit sl LEFT JOIN FETCH sl.output LEFT JOIN FETCH prop.deterministicLimit dl LEFT JOIN FETCH dl.output WHERE p.id = :patternId")
    public Optional<InstrumentGraphPatternEntity> findByIdWithAllDetails(@Param(value="patternId") Long var1);

    @Query(value="SELECT DISTINCT p FROM InstrumentGraphPatternEntity p LEFT JOIN FETCH p.instrument i LEFT JOIN FETCH p.folder f LEFT JOIN FETCH p.axes a LEFT JOIN FETCH p.properties prop LEFT JOIN FETCH prop.instrument LEFT JOIN FETCH prop.output LEFT JOIN FETCH prop.constant LEFT JOIN FETCH prop.statisticalLimit sl LEFT JOIN FETCH sl.output LEFT JOIN FETCH prop.deterministicLimit dl LEFT JOIN FETCH dl.output WHERE p.instrument.id = :instrumentId")
    public List<InstrumentGraphPatternEntity> findByInstrumentIdWithAllDetails(@Param(value="instrumentId") Long var1);

    public List<InstrumentGraphPatternEntity> findByFolderId(Long var1);

    public List<InstrumentGraphPatternEntity> findByFolderIsNull();

    @Query(value="SELECT p FROM InstrumentGraphPatternEntity p WHERE p.instrument.section.id = :sectionId")
    public List<InstrumentGraphPatternEntity> findByInstrumentSectionId(@Param(value="sectionId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT p FROM InstrumentGraphPatternEntity p LEFT JOIN FETCH p.instrument WHERE p.instrument.dam.id = :damId")
    public List<InstrumentGraphPatternEntity> findByInstrumentDamId(@Param(value="damId") Long var1);

    @Query(value="SELECT DISTINCT p FROM InstrumentGraphPatternEntity p LEFT JOIN FETCH p.instrument i LEFT JOIN FETCH i.dam LEFT JOIN FETCH p.folder f LEFT JOIN FETCH p.axes a LEFT JOIN FETCH p.properties prop LEFT JOIN FETCH prop.instrument LEFT JOIN FETCH prop.output LEFT JOIN FETCH prop.constant LEFT JOIN FETCH prop.statisticalLimit sl LEFT JOIN FETCH sl.output LEFT JOIN FETCH prop.deterministicLimit dl LEFT JOIN FETCH dl.output WHERE p.folder.dam.id = :damId ORDER BY p.folder.name ASC, p.name ASC")
    public List<InstrumentGraphPatternEntity> findByFolderDamIdWithAllDetails(@Param(value="damId") Long var1);

    @Query(value="SELECT DISTINCT p FROM InstrumentGraphPatternEntity p LEFT JOIN FETCH p.instrument i LEFT JOIN FETCH i.dam LEFT JOIN FETCH p.folder f LEFT JOIN FETCH p.axes a LEFT JOIN FETCH p.properties prop LEFT JOIN FETCH prop.instrument LEFT JOIN FETCH prop.output LEFT JOIN FETCH prop.constant LEFT JOIN FETCH prop.statisticalLimit sl LEFT JOIN FETCH sl.output LEFT JOIN FETCH prop.deterministicLimit dl LEFT JOIN FETCH dl.output WHERE p.folder.id = :folderId ORDER BY p.name ASC")
    public List<InstrumentGraphPatternEntity> findByFolderIdWithAllDetails(@Param(value="folderId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentGraphPatternEntity p LEFT JOIN FETCH p.instrument i LEFT JOIN FETCH p.folder f LEFT JOIN FETCH p.axes a LEFT JOIN FETCH p.properties props LEFT JOIN FETCH props.output o LEFT JOIN FETCH props.constant c LEFT JOIN FETCH props.statisticalLimit sl LEFT JOIN FETCH props.deterministicLimit dl LEFT JOIN FETCH props.instrument pi WHERE i.dam.id = :damId")
    public List<InstrumentGraphPatternEntity> findByInstrumentDamIdWithAllDetails(@Param(value="damId") Long var1);

    @Query(value="SELECT DISTINCT p FROM InstrumentGraphPatternEntity p LEFT JOIN FETCH p.instrument i LEFT JOIN FETCH i.dam LEFT JOIN FETCH p.axes a LEFT JOIN FETCH p.properties prop LEFT JOIN FETCH prop.instrument LEFT JOIN FETCH prop.output LEFT JOIN FETCH prop.constant LEFT JOIN FETCH prop.statisticalLimit sl LEFT JOIN FETCH sl.output LEFT JOIN FETCH prop.deterministicLimit dl LEFT JOIN FETCH dl.output WHERE p.instrument.dam.id = :damId AND p.folder IS NULL ORDER BY p.instrument.name ASC, p.name ASC")
    public List<InstrumentGraphPatternEntity> findByInstrumentDamIdWithoutFolderWithAllDetails(@Param(value="damId") Long var1);
}

