/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_customization_properties.services;

import com.geosegbar.common.enums.CustomizationTypeEnum;
import com.geosegbar.common.enums.LimitValueTypeEnum;
import com.geosegbar.common.enums.LineTypeEnum;
import com.geosegbar.entities.ConstantEntity;
import com.geosegbar.entities.DeterministicLimitEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.InstrumentGraphCustomizationPropertiesEntity;
import com.geosegbar.entities.InstrumentGraphPatternEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.entities.StatisticalLimitEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.constant.services.ConstantService;
import com.geosegbar.infra.deterministic_limit.services.DeterministicLimitService;
import com.geosegbar.infra.instrument.persistence.jpa.InstrumentRepository;
import com.geosegbar.infra.instrument.services.InstrumentService;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.GraphPropertiesResponseDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.PropertyResponseDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdateGraphPropertiesRequestDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdatePropertiesBatchRequestDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdatePropertiesBatchResponseDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.dtos.UpdatePropertyRequestDTO;
import com.geosegbar.infra.instrument_graph_customization_properties.persistence.jpa.InstrumentGraphCustomizationPropertiesRepository;
import com.geosegbar.infra.instrument_graph_customization_properties.services.InstrumentGraphCustomizationPropertiesService;
import com.geosegbar.infra.instrument_graph_pattern.services.InstrumentGraphPatternService;
import com.geosegbar.infra.output.persistence.jpa.OutputRepository;
import com.geosegbar.infra.output.services.OutputService;
import com.geosegbar.infra.statistical_limit.services.StatisticalLimitService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentGraphCustomizationPropertiesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentGraphCustomizationPropertiesService.class);
    private final InstrumentGraphCustomizationPropertiesRepository propertiesRepository;
    private final InstrumentGraphPatternService patternService;
    private final InstrumentService instrumentService;
    private final OutputService outputService;
    private final InstrumentRepository instrumentRepository;
    private final OutputRepository outputRepository;
    private final StatisticalLimitService statLimitService;
    private final DeterministicLimitService detLimitService;
    private final ConstantService constantService;

    @Transactional
    @CacheEvict(value={"graphProperties", "graphPatternById", "graphPatternsByInstrument", "graphPatternsByDam", "folderWithPatterns", "damFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public void updateProperties(Long patternId, UpdateGraphPropertiesRequestDTO req) {
        InstrumentGraphPatternEntity pattern = this.patternService.findById(patternId);
        List existingProperties = this.propertiesRepository.findByPatternId(patternId);
        Long damId = pattern.getInstrument().getDam().getId();
        this.validateAllElementsBelongToDam(req.getInstrumentIds(), req.getOutputIds(), req.getStatisticalLimitValues().stream().map(UpdateGraphPropertiesRequestDTO.StatisticalLimitValueReference::getLimitId).toList(), req.getDeterministicLimitValues().stream().map(UpdateGraphPropertiesRequestDTO.DeterministicLimitValueReference::getLimitId).toList(), req.getConstantIds(), damId);
        this.manageInstrumentProperties(pattern, existingProperties, this.getExistingInstrumentIds(existingProperties), new HashSet(req.getInstrumentIds()));
        this.manageOutputProperties(pattern, existingProperties, this.getExistingOutputIds(existingProperties), new HashSet(req.getOutputIds()));
        this.manageConstantProperties(pattern, existingProperties, this.getExistingConstantIds(existingProperties), new HashSet(req.getConstantIds()));
        this.manageStatisticalLimitValueProperties(pattern, existingProperties, req.getStatisticalLimitValues());
        this.manageDeterministicLimitValueProperties(pattern, existingProperties, req.getDeterministicLimitValues());
        log.info("Propriedades atualizadas para pattern: {}", (Object)patternId);
    }

    private void validateAllElementsBelongToDam(List<Long> instrumentIds, List<Long> outputIds, List<Long> statisticalLimitIds, List<Long> deterministicLimitIds, List<Long> constantIds, Long damId) {
        List<Long> invalidLimitIds;
        List<Long> validLimitIds;
        if (instrumentIds != null && !instrumentIds.isEmpty()) {
            List<Long> validInstrumentIds = this.instrumentRepository.findInstrumentIdsByDamId(damId).stream().filter(instrumentIds::contains).toList();
            List<Long> invalidInstrumentIds = instrumentIds.stream().filter(id -> !validInstrumentIds.contains(id)).toList();
            if (!invalidInstrumentIds.isEmpty()) {
                throw new InvalidInputException("Os seguintes instrumentos n\u00e3o pertencem \u00e0 mesma barragem do padr\u00e3o: " + String.valueOf(invalidInstrumentIds));
            }
        }
        if (outputIds != null && !outputIds.isEmpty()) {
            List<Long> validOutputIds = this.outputRepository.findOutputIdsByInstrumentDamId(damId).stream().filter(outputIds::contains).toList();
            List<Long> invalidOutputIds = outputIds.stream().filter(id -> !validOutputIds.contains(id)).toList();
            if (!invalidOutputIds.isEmpty()) {
                throw new InvalidInputException("Os seguintes outputs n\u00e3o pertencem \u00e0 mesma barragem do padr\u00e3o: " + String.valueOf(invalidOutputIds));
            }
        }
        if (constantIds != null && !constantIds.isEmpty()) {
            List<Long> validConstantIds = this.constantService.findConstantIdsByInstrumentDamId(damId).stream().filter(constantIds::contains).toList();
            List<Long> invalidConstantIds = constantIds.stream().filter(id -> !validConstantIds.contains(id)).toList();
            if (!invalidConstantIds.isEmpty()) {
                throw new InvalidInputException("As seguintes constantes n\u00e3o pertencem \u00e0 barragem selecionada: " + String.valueOf(invalidConstantIds));
            }
        }
        if (statisticalLimitIds != null && !statisticalLimitIds.isEmpty()) {
            validLimitIds = this.statLimitService.findStatisticalLimitIdsByOutputInstrumentDamId(damId).stream().filter(statisticalLimitIds::contains).toList();
            invalidLimitIds = statisticalLimitIds.stream().filter(id -> !validLimitIds.contains(id)).toList();
            if (!invalidLimitIds.isEmpty()) {
                throw new InvalidInputException("Os seguintes limites estat\u00edsticos n\u00e3o pertencem \u00e0 mesma barragem do padr\u00e3o: " + String.valueOf(invalidLimitIds));
            }
        }
        if (deterministicLimitIds != null && !deterministicLimitIds.isEmpty()) {
            validLimitIds = this.detLimitService.findDeterministicLimitIdsByOutputInstrumentDamId(damId).stream().filter(deterministicLimitIds::contains).toList();
            invalidLimitIds = deterministicLimitIds.stream().filter(id -> !validLimitIds.contains(id)).toList();
            if (!invalidLimitIds.isEmpty()) {
                throw new InvalidInputException("Os seguintes limites determin\u00edsticos n\u00e3o pertencem \u00e0 mesma barragem do padr\u00e3o: " + String.valueOf(invalidLimitIds));
            }
        }
    }

    @Transactional
    @CacheEvict(value={"graphProperties", "graphPatternById", "graphPatternsByInstrument", "graphPatternsByDam", "folderWithPatterns", "damFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public PropertyResponseDTO updateProperty(Long propertyId, UpdatePropertyRequestDTO req) {
        InstrumentGraphCustomizationPropertiesEntity property = (InstrumentGraphCustomizationPropertiesEntity)this.propertiesRepository.findById((Object)propertyId).orElseThrow(() -> new NotFoundException("Propriedade n\u00e3o encontrada com ID: " + propertyId));
        property.setName(req.getName());
        property.setFillColor(req.getFillColor());
        property.setLineType(req.getLineType());
        property.setLabelEnable(req.getLabelEnable());
        property.setIsPrimaryOrdinate(req.getIsPrimaryOrdinate());
        InstrumentGraphCustomizationPropertiesEntity savedProperty = (InstrumentGraphCustomizationPropertiesEntity)this.propertiesRepository.save((Object)property);
        return this.mapToPropertyResponseDTO(savedProperty);
    }

    @Transactional
    @CacheEvict(value={"graphProperties", "graphPatternById", "graphPatternsByInstrument", "graphPatternsByDam", "folderWithPatterns", "damFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public UpdatePropertiesBatchResponseDTO updatePropertiesBatch(Long patternId, UpdatePropertiesBatchRequestDTO req) {
        this.patternService.findById(patternId);
        List<Long> propertyIds = req.getProperties().stream().map(UpdatePropertiesBatchRequestDTO.PropertyUpdateItem::getId).toList();
        List existingProperties = this.propertiesRepository.findAllById(propertyIds);
        List<InstrumentGraphCustomizationPropertiesEntity> validProperties = existingProperties.stream().filter(prop -> prop.getPattern().getId().equals(patternId)).toList();
        Map<Long, InstrumentGraphCustomizationPropertiesEntity> propertyMap = validProperties.stream().collect(Collectors.toMap(InstrumentGraphCustomizationPropertiesEntity::getId, prop -> prop));
        ArrayList<PropertyResponseDTO> updatedProperties = new ArrayList<PropertyResponseDTO>();
        ArrayList<UpdatePropertiesBatchResponseDTO.PropertyUpdateError> errors = new ArrayList<UpdatePropertiesBatchResponseDTO.PropertyUpdateError>();
        HashMap statisticalLimitValueTypes = new HashMap();
        HashMap deterministicLimitValueTypes = new HashMap();
        for (UpdatePropertiesBatchRequestDTO.PropertyUpdateItem item : req.getProperties()) {
            try {
                InstrumentGraphCustomizationPropertiesEntity property = propertyMap.get(item.getId());
                if (property == null) {
                    throw new NotFoundException("Propriedade n\u00e3o encontrada ou n\u00e3o pertence ao padr\u00e3o: " + item.getId());
                }
                if (item.getLimitValueType() != null && !item.getLimitValueType().equals((Object)property.getLimitValueType())) {
                    if (property.getStatisticalLimit() != null) {
                        limitId = property.getStatisticalLimit().getId();
                        if (!statisticalLimitValueTypes.containsKey(limitId)) {
                            statisticalLimitValueTypes.put(limitId, new HashSet());
                        }
                        if (((Set)statisticalLimitValueTypes.get(limitId)).contains(item.getLimitValueType())) {
                            throw new InvalidInputException("Tipo de valor duplicado para limite estat\u00edstico: " + limitId);
                        }
                        this.validateUniqueValueType(patternId, limitId, null, item.getLimitValueType(), property.getId());
                        ((Set)statisticalLimitValueTypes.get(limitId)).add(item.getLimitValueType());
                    } else if (property.getDeterministicLimit() != null) {
                        limitId = property.getDeterministicLimit().getId();
                        if (!deterministicLimitValueTypes.containsKey(limitId)) {
                            deterministicLimitValueTypes.put(limitId, new HashSet());
                        }
                        if (((Set)deterministicLimitValueTypes.get(limitId)).contains(item.getLimitValueType())) {
                            throw new InvalidInputException("Tipo de valor duplicado para limite determin\u00edstico: " + limitId);
                        }
                        this.validateUniqueValueType(patternId, null, limitId, item.getLimitValueType(), property.getId());
                        ((Set)deterministicLimitValueTypes.get(limitId)).add(item.getLimitValueType());
                    }
                }
                property.setName(item.getName());
                property.setFillColor(item.getFillColor());
                property.setLineType(item.getLineType());
                property.setLabelEnable(item.getLabelEnable());
                property.setIsPrimaryOrdinate(item.getIsPrimaryOrdinate());
                updatedProperties.add(this.mapToPropertyResponseDTO(property));
            }
            catch (InvalidInputException | NotFoundException e) {
                errors.add(new UpdatePropertiesBatchResponseDTO.PropertyUpdateError(item.getId(), e.getMessage()));
                log.error("Erro ao atualizar propriedade em lote: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (Exception e) {
                errors.add(new UpdatePropertiesBatchResponseDTO.PropertyUpdateError(item.getId(), "Erro interno: " + e.getMessage()));
                log.error("Erro interno ao atualizar propriedade em lote: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (!validProperties.isEmpty()) {
            this.propertiesRepository.saveAll(validProperties);
        }
        log.info("Atualiza\u00e7\u00e3o em lote conclu\u00edda - Pattern: {}, Atualizadas: {}, Erros: {}", new Object[]{patternId, updatedProperties.size(), errors.size()});
        return new UpdatePropertiesBatchResponseDTO(patternId, Integer.valueOf(updatedProperties.size()), updatedProperties, errors);
    }

    @Cacheable(value={"graphProperties"}, key="'property-' + #propertyId", cacheManager="instrumentGraphCacheManager")
    public PropertyResponseDTO findPropertyById(Long propertyId) {
        InstrumentGraphCustomizationPropertiesEntity property = (InstrumentGraphCustomizationPropertiesEntity)this.propertiesRepository.findById((Object)propertyId).orElseThrow(() -> new NotFoundException("Propriedade n\u00e3o encontrada com ID: " + propertyId));
        return this.mapToPropertyResponseDTO(property);
    }

    @Cacheable(value={"graphProperties"}, key="'pattern-properties-' + #patternId", cacheManager="instrumentGraphCacheManager")
    public List<PropertyResponseDTO> findPropertiesByPatternId(Long patternId) {
        List properties = this.propertiesRepository.findByPatternId(patternId);
        return properties.stream().map(arg_0 -> this.mapToPropertyResponseDTO(arg_0)).toList();
    }

    @Cacheable(value={"graphProperties"}, key="'pattern-' + #patternId", cacheManager="instrumentGraphCacheManager")
    public GraphPropertiesResponseDTO findByPatternId(Long patternId) {
        this.patternService.findById(patternId);
        List properties = this.propertiesRepository.findByPatternId(patternId);
        List<GraphPropertiesResponseDTO.PropertyDetailDTO> propertyDetails = properties.stream().map(arg_0 -> this.mapToPropertyDetailDTO(arg_0)).toList();
        return new GraphPropertiesResponseDTO(patternId, propertyDetails);
    }

    private void validateUniqueValueType(Long patternId, Long statisticalLimitId, Long deterministicLimitId, LimitValueTypeEnum valueType, Long excludePropertyId) {
        List existingProperties;
        if (valueType == null) {
            return;
        }
        if (statisticalLimitId != null) {
            existingProperties = this.propertiesRepository.findByPatternIdAndStatisticalLimitIdAndLimitValueType(patternId, statisticalLimitId, valueType);
        } else if (deterministicLimitId != null) {
            existingProperties = this.propertiesRepository.findByPatternIdAndDeterministicLimitIdAndLimitValueType(patternId, deterministicLimitId, valueType);
        } else {
            return;
        }
        boolean hasDuplicate = existingProperties.stream().anyMatch(p -> !p.getId().equals(excludePropertyId));
        if (hasDuplicate) {
            String limitType = statisticalLimitId != null ? "estat\u00edstico" : "determin\u00edstico";
            throw new InvalidInputException("J\u00e1 existe uma propriedade para o limite " + limitType + " com o tipo de valor: " + String.valueOf(valueType));
        }
    }

    private void manageStatisticalLimitValueProperties(InstrumentGraphPatternEntity pattern, List<InstrumentGraphCustomizationPropertiesEntity> existingProperties, List<UpdateGraphPropertiesRequestDTO.StatisticalLimitValueReference> references) {
        Map existingLimitProps = this.mapExistingStatisticalLimitProperties(existingProperties);
        HashMap requestedValues = new HashMap();
        for (UpdateGraphPropertiesRequestDTO.StatisticalLimitValueReference ref : references) {
            if (!requestedValues.containsKey(ref.getLimitId())) {
                requestedValues.put(ref.getLimitId(), new HashSet());
            }
            if (((Set)requestedValues.get(ref.getLimitId())).contains(ref.getValueType())) {
                throw new InvalidInputException("Tipo de valor duplicado para limite estat\u00edstico: " + ref.getLimitId() + ", valor: " + String.valueOf(ref.getValueType()));
            }
            ((Set)requestedValues.get(ref.getLimitId())).add(ref.getValueType());
            if (ref.getValueType() == LimitValueTypeEnum.STATISTICAL_LOWER || ref.getValueType() == LimitValueTypeEnum.STATISTICAL_UPPER) continue;
            throw new InvalidInputException("Tipo de valor inv\u00e1lido para limite estat\u00edstico: " + String.valueOf(ref.getValueType()));
        }
        for (Long limitId : existingLimitProps.keySet()) {
            Map valueProps = (Map)existingLimitProps.get(limitId);
            if (!requestedValues.containsKey(limitId)) {
                for (InstrumentGraphCustomizationPropertiesEntity prop : valueProps.values()) {
                    this.propertiesRepository.delete((Object)prop);
                }
                continue;
            }
            Set requestedTypesForLimit = (Set)requestedValues.get(limitId);
            for (LimitValueTypeEnum valueType : valueProps.keySet()) {
                if (requestedTypesForLimit.contains(valueType)) continue;
                this.propertiesRepository.delete((Object)((InstrumentGraphCustomizationPropertiesEntity)valueProps.get(valueType)));
            }
        }
        for (UpdateGraphPropertiesRequestDTO.StatisticalLimitValueReference ref : references) {
            boolean exists = existingLimitProps.containsKey(ref.getLimitId()) && ((Map)existingLimitProps.get(ref.getLimitId())).containsKey(ref.getValueType());
            if (exists) continue;
            StatisticalLimitEntity statLimit = this.statLimitService.findById(ref.getLimitId());
            this.createCustomizationProperty(pattern, CustomizationTypeEnum.STATISTICAL_LIMIT, null, statLimit, null, null, null, ref.getValueType());
        }
    }

    private void manageDeterministicLimitValueProperties(InstrumentGraphPatternEntity pattern, List<InstrumentGraphCustomizationPropertiesEntity> existingProperties, List<UpdateGraphPropertiesRequestDTO.DeterministicLimitValueReference> references) {
        Map existingLimitProps = this.mapExistingDeterministicLimitProperties(existingProperties);
        HashMap requestedValues = new HashMap();
        for (UpdateGraphPropertiesRequestDTO.DeterministicLimitValueReference ref : references) {
            if (!requestedValues.containsKey(ref.getLimitId())) {
                requestedValues.put(ref.getLimitId(), new HashSet());
            }
            if (((Set)requestedValues.get(ref.getLimitId())).contains(ref.getValueType())) {
                throw new InvalidInputException("Tipo de valor duplicado para limite determin\u00edstico: " + ref.getLimitId() + ", valor: " + String.valueOf(ref.getValueType()));
            }
            ((Set)requestedValues.get(ref.getLimitId())).add(ref.getValueType());
            if (ref.getValueType() == LimitValueTypeEnum.DETERMINISTIC_ATTENTION || ref.getValueType() == LimitValueTypeEnum.DETERMINISTIC_ALERT || ref.getValueType() == LimitValueTypeEnum.DETERMINISTIC_EMERGENCY) continue;
            throw new InvalidInputException("Tipo de valor inv\u00e1lido para limite determin\u00edstico: " + String.valueOf(ref.getValueType()));
        }
        for (Long limitId : existingLimitProps.keySet()) {
            Map valueProps = (Map)existingLimitProps.get(limitId);
            if (!requestedValues.containsKey(limitId)) {
                for (InstrumentGraphCustomizationPropertiesEntity prop : valueProps.values()) {
                    this.propertiesRepository.delete((Object)prop);
                }
                continue;
            }
            Set requestedTypesForLimit = (Set)requestedValues.get(limitId);
            for (LimitValueTypeEnum valueType : valueProps.keySet()) {
                if (requestedTypesForLimit.contains(valueType)) continue;
                this.propertiesRepository.delete((Object)((InstrumentGraphCustomizationPropertiesEntity)valueProps.get(valueType)));
            }
        }
        for (UpdateGraphPropertiesRequestDTO.DeterministicLimitValueReference ref : references) {
            boolean exists = existingLimitProps.containsKey(ref.getLimitId()) && ((Map)existingLimitProps.get(ref.getLimitId())).containsKey(ref.getValueType());
            if (exists) continue;
            DeterministicLimitEntity detLimit = this.detLimitService.findById(ref.getLimitId());
            this.createCustomizationProperty(pattern, CustomizationTypeEnum.DETERMINISTIC_LIMIT, null, null, detLimit, null, null, ref.getValueType());
        }
    }

    private Map<Long, Map<LimitValueTypeEnum, InstrumentGraphCustomizationPropertiesEntity>> mapExistingStatisticalLimitProperties(List<InstrumentGraphCustomizationPropertiesEntity> properties) {
        HashMap<Long, Map<LimitValueTypeEnum, InstrumentGraphCustomizationPropertiesEntity>> result = new HashMap<Long, Map<LimitValueTypeEnum, InstrumentGraphCustomizationPropertiesEntity>>();
        for (InstrumentGraphCustomizationPropertiesEntity prop : properties) {
            if (prop.getCustomizationType() != CustomizationTypeEnum.STATISTICAL_LIMIT || prop.getStatisticalLimit() == null || prop.getLimitValueType() == null) continue;
            Long limitId = prop.getStatisticalLimit().getId();
            if (!result.containsKey(limitId)) {
                result.put(limitId, new HashMap());
            }
            ((Map)result.get(limitId)).put(prop.getLimitValueType(), prop);
        }
        return result;
    }

    private Map<Long, Map<LimitValueTypeEnum, InstrumentGraphCustomizationPropertiesEntity>> mapExistingDeterministicLimitProperties(List<InstrumentGraphCustomizationPropertiesEntity> properties) {
        HashMap<Long, Map<LimitValueTypeEnum, InstrumentGraphCustomizationPropertiesEntity>> result = new HashMap<Long, Map<LimitValueTypeEnum, InstrumentGraphCustomizationPropertiesEntity>>();
        for (InstrumentGraphCustomizationPropertiesEntity prop : properties) {
            if (prop.getCustomizationType() != CustomizationTypeEnum.DETERMINISTIC_LIMIT || prop.getDeterministicLimit() == null || prop.getLimitValueType() == null) continue;
            Long limitId = prop.getDeterministicLimit().getId();
            if (!result.containsKey(limitId)) {
                result.put(limitId, new HashMap());
            }
            ((Map)result.get(limitId)).put(prop.getLimitValueType(), prop);
        }
        return result;
    }

    private void manageInstrumentProperties(InstrumentGraphPatternEntity pattern, List<InstrumentGraphCustomizationPropertiesEntity> existingProperties, Set<Long> currentIds, Set<Long> newIds) {
        HashSet<Long> idsToRemove = new HashSet<Long>(currentIds);
        idsToRemove.removeAll(newIds);
        for (Long idToRemove : idsToRemove) {
            existingProperties.stream().filter(p -> p.getCustomizationType() == CustomizationTypeEnum.INSTRUMENT && p.getInstrument() != null && p.getInstrument().getId().equals(idToRemove)).forEach(arg_0 -> ((InstrumentGraphCustomizationPropertiesRepository)this.propertiesRepository).delete(arg_0));
        }
        HashSet<Long> idsToAdd = new HashSet<Long>(newIds);
        idsToAdd.removeAll(currentIds);
        for (Long idToAdd : idsToAdd) {
            InstrumentEntity instrument = this.instrumentService.findById(idToAdd);
            CustomizationTypeEnum customizationType = Boolean.TRUE.equals(instrument.getIsLinimetricRuler()) ? CustomizationTypeEnum.LINIMETRIC_RULER : CustomizationTypeEnum.INSTRUMENT;
            this.createCustomizationProperty(pattern, customizationType, null, null, null, instrument, null, null);
        }
    }

    private void manageConstantProperties(InstrumentGraphPatternEntity pattern, List<InstrumentGraphCustomizationPropertiesEntity> existingProperties, Set<Long> currentIds, Set<Long> newIds) {
        HashSet<Long> idsToRemove = new HashSet<Long>(currentIds);
        idsToRemove.removeAll(newIds);
        for (Long idToRemove : idsToRemove) {
            existingProperties.stream().filter(p -> p.getCustomizationType() == CustomizationTypeEnum.CONSTANT).filter(p -> p.getConstant() != null && p.getConstant().getId().equals(idToRemove)).findFirst().ifPresent(p -> this.propertiesRepository.delete(p));
        }
        HashSet<Long> idsToAdd = new HashSet<Long>(newIds);
        idsToAdd.removeAll(currentIds);
        for (Long idToAdd : idsToAdd) {
            ConstantEntity constant = this.constantService.findById(idToAdd);
            this.createCustomizationProperty(pattern, CustomizationTypeEnum.CONSTANT, null, null, null, null, constant, null);
        }
    }

    private void manageOutputProperties(InstrumentGraphPatternEntity pattern, List<InstrumentGraphCustomizationPropertiesEntity> existingProperties, Set<Long> currentIds, Set<Long> newIds) {
        HashSet<Long> idsToRemove = new HashSet<Long>(currentIds);
        idsToRemove.removeAll(newIds);
        for (Long idToRemove : idsToRemove) {
            existingProperties.stream().filter(p -> p.getCustomizationType() == CustomizationTypeEnum.OUTPUT && p.getOutput() != null && p.getOutput().getId().equals(idToRemove)).forEach(arg_0 -> ((InstrumentGraphCustomizationPropertiesRepository)this.propertiesRepository).delete(arg_0));
        }
        HashSet<Long> idsToAdd = new HashSet<Long>(newIds);
        idsToAdd.removeAll(currentIds);
        for (Long idToAdd : idsToAdd) {
            OutputEntity output = this.outputService.findById(idToAdd);
            this.createCustomizationProperty(pattern, CustomizationTypeEnum.OUTPUT, output, null, null, null, null, null);
        }
    }

    private void createCustomizationProperty(InstrumentGraphPatternEntity pattern, CustomizationTypeEnum type, OutputEntity output, StatisticalLimitEntity statLimit, DeterministicLimitEntity detLimit, InstrumentEntity instrument, ConstantEntity constant, LimitValueTypeEnum limitValueType) {
        InstrumentGraphCustomizationPropertiesEntity property = new InstrumentGraphCustomizationPropertiesEntity();
        property.setName(null);
        property.setPattern(pattern);
        property.setCustomizationType(type);
        property.setLimitValueType(limitValueType);
        if (type == CustomizationTypeEnum.STATISTICAL_LIMIT && limitValueType != null) {
            switch (1.$SwitchMap$com$geosegbar$common$enums$LimitValueTypeEnum[limitValueType.ordinal()]) {
                case 1: {
                    property.setFillColor("#00AA00");
                    property.setLineType(LineTypeEnum.DASHED);
                    break;
                }
                case 2: {
                    property.setFillColor("#AA0000");
                    property.setLineType(LineTypeEnum.DASHED);
                    break;
                }
                default: {
                    property.setFillColor("#000000");
                    property.setLineType(LineTypeEnum.SOLID);
                    break;
                }
            }
        } else if (type == CustomizationTypeEnum.DETERMINISTIC_LIMIT && limitValueType != null) {
            switch (1.$SwitchMap$com$geosegbar$common$enums$LimitValueTypeEnum[limitValueType.ordinal()]) {
                case 3: {
                    property.setFillColor("#FFFF00");
                    property.setLineType(LineTypeEnum.DASHED);
                    break;
                }
                case 4: {
                    property.setFillColor("#FFA500");
                    property.setLineType(LineTypeEnum.DASHED);
                    break;
                }
                case 5: {
                    property.setFillColor("#FF0000");
                    property.setLineType(LineTypeEnum.DASHED);
                    break;
                }
                default: {
                    property.setFillColor("#000000");
                    property.setLineType(LineTypeEnum.SOLID);
                    break;
                }
            }
        } else if (type == CustomizationTypeEnum.OUTPUT) {
            property.setFillColor("#FF0000");
            property.setLineType(LineTypeEnum.SOLID);
        } else if (type == CustomizationTypeEnum.INSTRUMENT) {
            property.setFillColor("#0000FF");
            property.setLineType(LineTypeEnum.SOLID);
        } else if (type == CustomizationTypeEnum.LINIMETRIC_RULER) {
            property.setFillColor("#00FFFF");
            property.setLineType(LineTypeEnum.SOLID);
        } else if (type == CustomizationTypeEnum.CONSTANT) {
            property.setFillColor("#800080");
            property.setLineType(LineTypeEnum.SOLID);
        } else {
            property.setFillColor("#000000");
            property.setLineType(LineTypeEnum.SOLID);
        }
        property.setLabelEnable(Boolean.valueOf(true));
        property.setIsPrimaryOrdinate(Boolean.valueOf(true));
        switch (1.$SwitchMap$com$geosegbar$common$enums$CustomizationTypeEnum[type.ordinal()]) {
            case 1: {
                property.setOutput(output);
                break;
            }
            case 2: {
                property.setStatisticalLimit(statLimit);
                break;
            }
            case 3: {
                property.setDeterministicLimit(detLimit);
                break;
            }
            case 4: 
            case 5: {
                if (!(type != CustomizationTypeEnum.LINIMETRIC_RULER || instrument != null && Boolean.TRUE.equals(instrument.getIsLinimetricRuler()))) {
                    throw new InvalidInputException("O instrumento selecionado n\u00e3o \u00e9 uma r\u00e9gua linim\u00e9trica");
                }
                property.setInstrument(instrument);
                break;
            }
            case 6: {
                property.setConstant(constant);
            }
        }
        this.propertiesRepository.save((Object)property);
        log.info("Criada nova propriedade de customiza\u00e7\u00e3o: tipo={}, limitValueType={}, patternId={}", new Object[]{type, limitValueType, pattern.getId()});
    }

    private PropertyResponseDTO mapToPropertyResponseDTO(InstrumentGraphCustomizationPropertiesEntity property) {
        PropertyResponseDTO dto = new PropertyResponseDTO();
        dto.setId(property.getId());
        dto.setName(property.getName());
        dto.setCustomizationType(property.getCustomizationType());
        dto.setFillColor(property.getFillColor());
        dto.setLineType(property.getLineType());
        dto.setLabelEnable(property.getLabelEnable());
        dto.setIsPrimaryOrdinate(property.getIsPrimaryOrdinate());
        dto.setPatternId(property.getPattern().getId());
        dto.setLimitValueType(property.getLimitValueType());
        if (property.getInstrument() != null) {
            dto.setInstrumentId(property.getInstrument().getId());
        }
        if (property.getOutput() != null) {
            dto.setOutputId(property.getOutput().getId());
        }
        if (property.getConstant() != null) {
            dto.setConstantId(property.getConstant().getId());
        }
        if (property.getStatisticalLimit() != null) {
            dto.setStatisticalLimitId(property.getStatisticalLimit().getId());
        }
        if (property.getDeterministicLimit() != null) {
            dto.setDeterministicLimitId(property.getDeterministicLimit().getId());
        }
        return dto;
    }

    private GraphPropertiesResponseDTO.PropertyDetailDTO mapToPropertyDetailDTO(InstrumentGraphCustomizationPropertiesEntity property) {
        GraphPropertiesResponseDTO.OutputDetailDTO outputDto;
        GraphPropertiesResponseDTO.PropertyDetailDTO dto = new GraphPropertiesResponseDTO.PropertyDetailDTO();
        dto.setId(property.getId());
        dto.setName(property.getName());
        dto.setCustomizationType(property.getCustomizationType());
        dto.setFillColor(property.getFillColor());
        dto.setLineType(property.getLineType());
        dto.setLabelEnable(property.getLabelEnable());
        dto.setIsPrimaryOrdinate(property.getIsPrimaryOrdinate());
        dto.setLimitValueType(property.getLimitValueType());
        if (property.getInstrument() != null) {
            dto.setInstrument(new GraphPropertiesResponseDTO.InstrumentDetailDTO(property.getInstrument().getId(), property.getInstrument().getName(), property.getInstrument().getLocation()));
        }
        if (property.getOutput() != null) {
            dto.setOutput(new GraphPropertiesResponseDTO.OutputDetailDTO(property.getOutput().getId(), property.getOutput().getAcronym(), property.getOutput().getName()));
        }
        if (property.getConstant() != null) {
            dto.setConstant(new GraphPropertiesResponseDTO.ConstantDetailDTO(property.getConstant().getId(), property.getConstant().getAcronym(), property.getConstant().getName(), property.getConstant().getValue()));
        }
        if (property.getStatisticalLimit() != null) {
            StatisticalLimitEntity statLimit = property.getStatisticalLimit();
            outputDto = null;
            if (statLimit.getOutput() != null) {
                outputDto = new GraphPropertiesResponseDTO.OutputDetailDTO(statLimit.getOutput().getId(), statLimit.getOutput().getAcronym(), statLimit.getOutput().getName());
            }
            dto.setStatisticalLimit(new GraphPropertiesResponseDTO.StatisticalLimitDetailDTO(statLimit.getId(), statLimit.getLowerValue(), statLimit.getUpperValue(), outputDto));
        }
        if (property.getDeterministicLimit() != null) {
            DeterministicLimitEntity detLimit = property.getDeterministicLimit();
            outputDto = null;
            if (detLimit.getOutput() != null) {
                outputDto = new GraphPropertiesResponseDTO.OutputDetailDTO(detLimit.getOutput().getId(), detLimit.getOutput().getAcronym(), detLimit.getOutput().getName());
            }
            dto.setDeterministicLimit(new GraphPropertiesResponseDTO.DeterministicLimitDetailDTO(detLimit.getId(), detLimit.getAttentionValue(), detLimit.getAlertValue(), detLimit.getEmergencyValue(), outputDto));
        }
        return dto;
    }

    private Set<Long> getExistingInstrumentIds(List<InstrumentGraphCustomizationPropertiesEntity> properties) {
        return properties.stream().filter(p -> p.getCustomizationType() == CustomizationTypeEnum.INSTRUMENT || p.getCustomizationType() == CustomizationTypeEnum.LINIMETRIC_RULER).filter(p -> p.getInstrument() != null).map(p -> p.getInstrument().getId()).collect(Collectors.toSet());
    }

    private Set<Long> getExistingOutputIds(List<InstrumentGraphCustomizationPropertiesEntity> properties) {
        return properties.stream().filter(p -> p.getCustomizationType() == CustomizationTypeEnum.OUTPUT).filter(p -> p.getOutput() != null).map(p -> p.getOutput().getId()).collect(Collectors.toSet());
    }

    private Set<Long> getExistingConstantIds(List<InstrumentGraphCustomizationPropertiesEntity> properties) {
        return properties.stream().filter(p -> p.getCustomizationType() == CustomizationTypeEnum.CONSTANT).filter(p -> p.getConstant() != null).map(p -> p.getConstant().getId()).collect(Collectors.toSet());
    }

    @Generated
    public InstrumentGraphCustomizationPropertiesService(InstrumentGraphCustomizationPropertiesRepository propertiesRepository, InstrumentGraphPatternService patternService, InstrumentService instrumentService, OutputService outputService, InstrumentRepository instrumentRepository, OutputRepository outputRepository, StatisticalLimitService statLimitService, DeterministicLimitService detLimitService, ConstantService constantService) {
        this.propertiesRepository = propertiesRepository;
        this.patternService = patternService;
        this.instrumentService = instrumentService;
        this.outputService = outputService;
        this.instrumentRepository = instrumentRepository;
        this.outputRepository = outputRepository;
        this.statLimitService = statLimitService;
        this.detLimitService = detLimitService;
        this.constantService = constantService;
    }
}

