/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.documentation_dam.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.DocumentationDamEntity;
import com.geosegbar.infra.documentation_dam.dtos.DocumentationDamDTO;
import com.geosegbar.infra.documentation_dam.services.DocumentationDamService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/documentation-dam"})
public class DocumentationDamController {
    private final DocumentationDamService documentationDamService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<DocumentationDamEntity>>> getAllDocumentations() {
        List documentations = this.documentationDamService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)documentations, (String)"Documenta\u00e7\u00f5es de barragens obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<DocumentationDamEntity>> getDocumentationById(@PathVariable Long id) {
        DocumentationDamEntity documentation = this.documentationDamService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)documentation, (String)"Documenta\u00e7\u00e3o de barragem obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<DocumentationDamEntity>> getDocumentationByDamId(@PathVariable Long damId) {
        DocumentationDamEntity documentation = this.documentationDamService.findByDamId(damId);
        WebResponseEntity response = WebResponseEntity.success((Object)documentation, (String)"Documenta\u00e7\u00e3o de barragem obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<DocumentationDamEntity>> createDocumentation(@Valid @RequestBody DocumentationDamDTO documentationDTO) {
        DocumentationDamEntity createdDocumentation = this.documentationDamService.createOrUpdate(documentationDTO);
        WebResponseEntity response = WebResponseEntity.success((Object)createdDocumentation, (String)"Documenta\u00e7\u00e3o de barragem criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<DocumentationDamEntity>> updateDocumentation(@PathVariable Long id, @Valid @RequestBody DocumentationDamDTO documentationDTO) {
        documentationDTO.setId(id);
        DocumentationDamEntity updatedDocumentation = this.documentationDamService.createOrUpdate(documentationDTO);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedDocumentation, (String)"Documenta\u00e7\u00e3o de barragem atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteDocumentation(@PathVariable Long id) {
        this.documentationDamService.delete(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Documenta\u00e7\u00e3o de barragem exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public DocumentationDamController(DocumentationDamService documentationDamService) {
        this.documentationDamService = documentationDamService;
    }
}

