/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.client.service;

import com.geosegbar.entities.ClientEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.FileStorageException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.client.dtos.LogoUpdateDTO;
import com.geosegbar.infra.client.persistence.jpa.ClientRepository;
import com.geosegbar.infra.file_storage.FileStorageService;
import jakarta.transaction.Transactional;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ClientService {
    private final ClientRepository clientRepository;
    private final FileStorageService fileStorageService;

    @Transactional
    public void deleteById(Long id) {
        ClientEntity client = (ClientEntity)this.clientRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado para exclus\u00e3o!"));
        if (client.getLogoPath() != null) {
            this.fileStorageService.deleteFile(client.getLogoPath());
        }
        this.clientRepository.deleteById((Object)id);
    }

    @Transactional
    public ClientEntity save(ClientEntity clientEntity) {
        if (this.clientRepository.existsByName(clientEntity.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe um cliente com este nome!");
        }
        if (this.clientRepository.existsByEmail(clientEntity.getEmail())) {
            throw new DuplicateResourceException("J\u00e1 existe um cliente com este email!");
        }
        String logoBase64 = clientEntity.getLogoPath();
        if (logoBase64 != null) {
            String logoPath = this.processAndSaveLogo(logoBase64);
            clientEntity.setLogoPath(logoPath);
        } else {
            clientEntity.setLogoPath(null);
        }
        return (ClientEntity)this.clientRepository.save((Object)clientEntity);
    }

    @Transactional
    public ClientEntity update(ClientEntity clientEntity) {
        ClientEntity existingClient = (ClientEntity)this.clientRepository.findById((Object)clientEntity.getId()).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado para atualiza\u00e7\u00e3o!"));
        if (this.clientRepository.existsByNameAndIdNot(clientEntity.getName(), clientEntity.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um cliente com este nome.");
        }
        if (this.clientRepository.existsByEmailAndIdNot(clientEntity.getEmail(), clientEntity.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um cliente com este email.");
        }
        if (existingClient.getLogoPath() != null) {
            clientEntity.setLogoPath(existingClient.getLogoPath());
        } else {
            clientEntity.setLogoPath(null);
        }
        return (ClientEntity)this.clientRepository.save((Object)clientEntity);
    }

    @Transactional
    public ClientEntity updateLogo(Long clientId, LogoUpdateDTO logoUpdateDTO) {
        String logoBase64;
        ClientEntity client = this.findById(clientId);
        if (client.getLogoPath() != null) {
            this.fileStorageService.deleteFile(client.getLogoPath());
            client.setLogoPath(null);
        }
        if ((logoBase64 = logoUpdateDTO.getLogoBase64()) != null) {
            String logoPath = this.processAndSaveLogo(logoBase64);
            client.setLogoPath(logoPath);
        }
        return (ClientEntity)this.clientRepository.save((Object)client);
    }

    private String processAndSaveLogo(String base64Image) {
        try {
            if (base64Image.contains(",")) {
                base64Image = base64Image.split(",")[1];
            }
            byte[] imageBytes = Base64.getDecoder().decode(base64Image);
            return this.fileStorageService.storeFileFromBytes(imageBytes, "client_logo.png", "image/png", "client-logos");
        }
        catch (IllegalArgumentException e) {
            throw new FileStorageException("Formato de imagem inv\u00e1lido", (Throwable)e);
        }
    }

    public ClientEntity findById(Long id) {
        return (ClientEntity)this.clientRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado!"));
    }

    public List<ClientEntity> findAll() {
        return this.clientRepository.findAllByOrderByIdAsc();
    }

    public List<ClientEntity> findByStatus(Long statusId) {
        if (statusId == null) {
            throw new NotFoundException("Status n\u00e3o informado para filtro de clientes!");
        }
        List clients = this.clientRepository.findByStatus(statusId);
        return clients;
    }

    public boolean existsByName(String name) {
        return this.clientRepository.existsByName(name);
    }

    public boolean existsByNameAndIdNot(String name, Long id) {
        return this.clientRepository.existsByNameAndIdNot(name, id);
    }

    public boolean existsByEmail(String email) {
        return this.clientRepository.existsByEmail(email);
    }

    public boolean existsByEmailAndIdNot(String email, Long id) {
        return this.clientRepository.existsByEmailAndIdNot(email, id);
    }

    @Generated
    public ClientService(ClientRepository clientRepository, FileStorageService fileStorageService) {
        this.clientRepository = clientRepository;
        this.fileStorageService = fileStorageService;
    }
}

