/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.geosegbar.entities.AnswerPhotoEntity;
import com.geosegbar.entities.OptionEntity;
import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.entities.QuestionnaireResponseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@Table(name="answers", indexes={@Index(name="idx_answer_question", columnList="question_id"), @Index(name="idx_answer_questionnaire", columnList="questionnaire_response_id"), @Index(name="idx_answer_coords", columnList="latitude, longitude")})
public class AnswerEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull(message="Informe a inst\u00e2ncia do question\u00e1rio!")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="questionnaire_response_id", nullable=false)
    @JsonBackReference(value="questionnaire-response-answers")
    private @NotNull(message="Informe a inst\u00e2ncia do question\u00e1rio!") QuestionnaireResponseEntity questionnaireResponse;
    @NotNull(message="Informe a pergunta que esta sendo respondida!")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="question_id", nullable=false)
    private @NotNull(message="Informe a pergunta que esta sendo respondida!") QuestionEntity question;
    @Column(name="comment", columnDefinition="TEXT")
    private String comment;
    @Column(name="latitude")
    private Double latitude;
    @Column(name="longitude")
    private Double longitude;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="answer_options", joinColumns={@JoinColumn(name="answer_id")}, inverseJoinColumns={@JoinColumn(name="option_id")})
    private Set<OptionEntity> selectedOptions = new HashSet();
    @OneToMany(mappedBy="answer", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonManagedReference(value="answer-photos")
    private Set<AnswerPhotoEntity> photos = new HashSet();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public QuestionnaireResponseEntity getQuestionnaireResponse() {
        return this.questionnaireResponse;
    }

    @Generated
    public QuestionEntity getQuestion() {
        return this.question;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Generated
    public Set<OptionEntity> getSelectedOptions() {
        return this.selectedOptions;
    }

    @Generated
    public Set<AnswerPhotoEntity> getPhotos() {
        return this.photos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setQuestionnaireResponse(QuestionnaireResponseEntity questionnaireResponse) {
        this.questionnaireResponse = questionnaireResponse;
    }

    @Generated
    public void setQuestion(QuestionEntity question) {
        this.question = question;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setSelectedOptions(Set<OptionEntity> selectedOptions) {
        this.selectedOptions = selectedOptions;
    }

    @Generated
    public void setPhotos(Set<AnswerPhotoEntity> photos) {
        this.photos = photos;
    }

    @Generated
    public AnswerEntity() {
    }

    @Generated
    public AnswerEntity(Long id, QuestionnaireResponseEntity questionnaireResponse, QuestionEntity question, String comment, Double latitude, Double longitude, Set<OptionEntity> selectedOptions, Set<AnswerPhotoEntity> photos) {
        this.id = id;
        this.questionnaireResponse = questionnaireResponse;
        this.question = question;
        this.comment = comment;
        this.latitude = latitude;
        this.longitude = longitude;
        this.selectedOptions = selectedOptions;
        this.photos = photos;
    }
}

