/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.template_questionnaire_question.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.TemplateQuestionnaireQuestionEntity;
import com.geosegbar.infra.template_questionnaire_question.dtos.QuestionReorderDTO;
import com.geosegbar.infra.template_questionnaire_question.services.TemplateQuestionnaireQuestionService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/template-questionnaire-questions"})
public class TemplateQuestionnaireQuestionController {
    private final TemplateQuestionnaireQuestionService templateQuestionnaireQuestionService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<TemplateQuestionnaireQuestionEntity>>> getAllTemplateQuestions() {
        List<TemplateQuestionnaireQuestionEntity> list = this.templateQuestionnaireQuestionService.findAll();
        WebResponseEntity<List<TemplateQuestionnaireQuestionEntity>> response = WebResponseEntity.success(list, "Quest\u00f5es do template obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TemplateQuestionnaireQuestionEntity>> getTemplateQuestionById(@PathVariable Long id) {
        TemplateQuestionnaireQuestionEntity entity = this.templateQuestionnaireQuestionService.findById(id);
        WebResponseEntity<TemplateQuestionnaireQuestionEntity> response = WebResponseEntity.success(entity, "Quest\u00e3o do template obtida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<TemplateQuestionnaireQuestionEntity>> createTemplateQuestion(@Valid @RequestBody TemplateQuestionnaireQuestionEntity entity) {
        TemplateQuestionnaireQuestionEntity created = this.templateQuestionnaireQuestionService.save(entity);
        WebResponseEntity<TemplateQuestionnaireQuestionEntity> response = WebResponseEntity.success(created, "Quest\u00e3o do template criada com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/reorder"})
    public ResponseEntity<WebResponseEntity<List<TemplateQuestionnaireQuestionEntity>>> reorderQuestions(@Valid @RequestBody QuestionReorderDTO reorderDTO) {
        List<TemplateQuestionnaireQuestionEntity> reorderedQuestions = this.templateQuestionnaireQuestionService.reorderQuestions(reorderDTO);
        WebResponseEntity<List<TemplateQuestionnaireQuestionEntity>> response = WebResponseEntity.success(reorderedQuestions, "Quest\u00f5es reordenadas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TemplateQuestionnaireQuestionEntity>> updateTemplateQuestion(@PathVariable Long id, @Valid @RequestBody TemplateQuestionnaireQuestionEntity entity) {
        entity.setId(id);
        TemplateQuestionnaireQuestionEntity updated = this.templateQuestionnaireQuestionService.update(entity);
        WebResponseEntity<TemplateQuestionnaireQuestionEntity> response = WebResponseEntity.success(updated, "Quest\u00e3o do template atualizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteTemplateQuestion(@PathVariable Long id) {
        this.templateQuestionnaireQuestionService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Quest\u00e3o do template exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public TemplateQuestionnaireQuestionController(TemplateQuestionnaireQuestionService templateQuestionnaireQuestionService) {
        this.templateQuestionnaireQuestionService = templateQuestionnaireQuestionService;
    }
}

