/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.template_questionnaire.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.TemplateQuestionnaireEntity;
import com.geosegbar.infra.template_questionnaire.dtos.TemplateQuestionnaireCreationDTO;
import com.geosegbar.infra.template_questionnaire.services.TemplateQuestionnaireService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/template-questionnaires"})
public class TemplateQuestionnaireController {
    private final TemplateQuestionnaireService templateQuestionnaireService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<TemplateQuestionnaireEntity>>> getAllTemplates() {
        List<TemplateQuestionnaireEntity> templates = this.templateQuestionnaireService.findAll();
        WebResponseEntity<List<TemplateQuestionnaireEntity>> response = WebResponseEntity.success(templates, "Templates obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TemplateQuestionnaireEntity>> getTemplateById(@PathVariable Long id) {
        TemplateQuestionnaireEntity template = this.templateQuestionnaireService.findById(id);
        WebResponseEntity<TemplateQuestionnaireEntity> response = WebResponseEntity.success(template, "Template obtido com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/checklist/{checklistId}"})
    public ResponseEntity<WebResponseEntity<List<TemplateQuestionnaireEntity>>> getTemplatesByChecklistId(@PathVariable Long checklistId) {
        List<TemplateQuestionnaireEntity> templates = this.templateQuestionnaireService.findByChecklistId(checklistId);
        WebResponseEntity<List<TemplateQuestionnaireEntity>> response = WebResponseEntity.success(templates, "Templates do checklist obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<TemplateQuestionnaireEntity>> createTemplate(@Valid @RequestBody TemplateQuestionnaireEntity template) {
        TemplateQuestionnaireEntity created = this.templateQuestionnaireService.save(template);
        WebResponseEntity<TemplateQuestionnaireEntity> response = WebResponseEntity.success(created, "Template criado com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/with-questions"})
    public ResponseEntity<WebResponseEntity<TemplateQuestionnaireEntity>> createTemplateWithQuestions(@Valid @RequestBody TemplateQuestionnaireCreationDTO creationDto) {
        TemplateQuestionnaireEntity created = this.templateQuestionnaireService.createWithQuestions(creationDto);
        WebResponseEntity<TemplateQuestionnaireEntity> response = WebResponseEntity.success(created, "Template de question\u00e1rio e suas quest\u00f5es criadas com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TemplateQuestionnaireEntity>> updateTemplate(@PathVariable Long id, @Valid @RequestBody TemplateQuestionnaireEntity template) {
        template.setId(id);
        TemplateQuestionnaireEntity updated = this.templateQuestionnaireService.update(template);
        WebResponseEntity<TemplateQuestionnaireEntity> response = WebResponseEntity.success(updated, "Template atualizado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteTemplate(@PathVariable Long id) {
        this.templateQuestionnaireService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Template exclu\u00eddo com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public TemplateQuestionnaireController(TemplateQuestionnaireService templateQuestionnaireService) {
        this.templateQuestionnaireService = templateQuestionnaireService;
    }
}

