/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.status.services;

import com.geosegbar.common.enums.StatusEnum;
import com.geosegbar.entities.StatusEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.status.persistence.jpa.StatusRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class StatusService {
    private final StatusRepository statusRepository;

    @PostConstruct
    public void initializeStatuses() {
        if (this.statusRepository.findByStatus(StatusEnum.ACTIVE).isEmpty()) {
            StatusEntity activeStatus = new StatusEntity();
            activeStatus.setStatus(StatusEnum.ACTIVE);
            this.statusRepository.save(activeStatus);
        }
        if (this.statusRepository.findByStatus(StatusEnum.DISABLED).isEmpty()) {
            StatusEntity disabledStatus = new StatusEntity();
            disabledStatus.setStatus(StatusEnum.DISABLED);
            this.statusRepository.save(disabledStatus);
        }
    }

    public StatusEntity getActiveStatus() {
        return this.statusRepository.findByStatus(StatusEnum.ACTIVE).orElseThrow(() -> new NotFoundException("Status ATIVO n\u00e3o encontrado!"));
    }

    public StatusEntity getDisabledStatus() {
        return this.statusRepository.findByStatus(StatusEnum.DISABLED).orElseThrow(() -> new NotFoundException("Status DESATIVADO n\u00e3o encontrado!"));
    }

    public StatusEntity findById(Long id) {
        return (StatusEntity)this.statusRepository.findById(id).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado!"));
    }

    public List<StatusEntity> findAll() {
        return this.statusRepository.findAll();
    }

    @Transactional
    public StatusEntity update(StatusEntity status) {
        this.statusRepository.findById(status.getId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado!"));
        return (StatusEntity)this.statusRepository.save(status);
    }

    @Generated
    public StatusService(StatusRepository statusRepository) {
        this.statusRepository = statusRepository;
    }
}

