/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.psb.services;

import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.PSBFolderEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.psb.dtos.CreatePSBFolderRequest;
import com.geosegbar.infra.psb.dtos.PSBFolderCreationDTO;
import com.geosegbar.infra.psb.persistence.PSBFolderRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PSBFolderService {
    @Value(value="${file.psb-dir:${file.upload-dir}/psb}")
    private String psbBaseDir;
    @Value(value="${file.base-url}")
    private String baseUrl;
    private final PSBFolderRepository psbFolderRepository;
    private final DamRepository damRepository;
    private final UserRepository userRepository;

    public List<PSBFolderEntity> findAllByDamId(Long damId) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getViewPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para acessar as pastas PSB");
        }
        return this.psbFolderRepository.findByDamIdOrderByFolderIndexAsc(damId);
    }

    public PSBFolderEntity findById(Long id) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getViewPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para acessar as pastas PSB");
        }
        return (PSBFolderEntity)this.psbFolderRepository.findById(id).orElseThrow(() -> new NotFoundException("Pasta PSB n\u00e3o encontrada"));
    }

    @Transactional
    public PSBFolderEntity create(CreatePSBFolderRequest request) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getEditPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para criar pastas PSB!");
        }
        DamEntity dam = (DamEntity)this.damRepository.findById(request.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada"));
        UserEntity currentUser = (UserEntity)this.userRepository.findById(request.getCreatedById()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado"));
        if (this.psbFolderRepository.existsByDamIdAndName(dam.getId(), request.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta com este nome nesta barragem");
        }
        if (this.psbFolderRepository.existsByDamIdAndFolderIndex(dam.getId(), request.getFolderIndex())) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta com este \u00edndice nesta barragem");
        }
        String folderPath = this.createFolderPath(dam.getId(), request.getFolderIndex(), request.getName());
        this.ensureDirectoryExists(folderPath);
        PSBFolderEntity folder = new PSBFolderEntity();
        folder.setName(request.getName());
        folder.setFolderIndex(request.getFolderIndex());
        folder.setDescription(request.getDescription());
        folder.setDam(dam);
        folder.setServerPath(folderPath);
        folder.setCreatedBy(currentUser);
        folder.setColor(request.getColor());
        return (PSBFolderEntity)this.psbFolderRepository.save(folder);
    }

    @Transactional
    public PSBFolderEntity update(Long id, CreatePSBFolderRequest request) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getEditPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para editar pastas do PSB!");
        }
        PSBFolderEntity existingFolder = (PSBFolderEntity)this.psbFolderRepository.findById(id).orElseThrow(() -> new NotFoundException("Pasta PSB n\u00e3o encontrada"));
        if (!existingFolder.getName().equals(request.getName()) && this.psbFolderRepository.existsByDamIdAndName(existingFolder.getDam().getId(), request.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta com este nome nesta barragem");
        }
        if (!existingFolder.getFolderIndex().equals(request.getFolderIndex()) && this.psbFolderRepository.existsByDamIdAndFolderIndex(existingFolder.getDam().getId(), request.getFolderIndex())) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta com este \u00edndice nesta barragem");
        }
        if (!existingFolder.getName().equals(request.getName()) || !existingFolder.getFolderIndex().equals(request.getFolderIndex())) {
            String newFolderPath = this.createFolderPath(existingFolder.getDam().getId(), request.getFolderIndex(), request.getName());
            Path oldPath = Paths.get(existingFolder.getServerPath(), new String[0]);
            Path newPath = Paths.get(newFolderPath, new String[0]);
            try {
                this.ensureDirectoryExists(newFolderPath);
                if (Files.exists(oldPath, new LinkOption[0]) && Files.isDirectory(oldPath, new LinkOption[0])) {
                    Files.list(oldPath).forEach(file -> {
                        try {
                            Files.move(file, newPath.resolve(file.getFileName()), new CopyOption[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Falha ao mover arquivos: " + e.getMessage());
                        }
                    });
                    Files.deleteIfExists(oldPath);
                }
                existingFolder.setServerPath(newFolderPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Falha ao atualizar diret\u00f3rio: " + e.getMessage());
            }
        }
        existingFolder.setName(request.getName());
        existingFolder.setFolderIndex(request.getFolderIndex());
        existingFolder.setDescription(request.getDescription());
        existingFolder.setUpdatedAt(LocalDateTime.now());
        existingFolder.setColor(request.getColor());
        return (PSBFolderEntity)this.psbFolderRepository.save(existingFolder);
    }

    @Transactional
    public void delete(Long id) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getEditPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para deletar pastas do PSB!");
        }
        PSBFolderEntity folderToDelete = (PSBFolderEntity)this.psbFolderRepository.findById(id).orElseThrow(() -> new NotFoundException("Pasta PSB n\u00e3o encontrada"));
        Long damId = folderToDelete.getDam().getId();
        Integer deletedFolderIndex = folderToDelete.getFolderIndex();
        try {
            Path folderPath = Paths.get(folderToDelete.getServerPath(), new String[0]);
            if (Files.exists(folderPath, new LinkOption[0])) {
                Files.walk(folderPath, new FileVisitOption[0]).sorted((a, b) -> b.toString().length() - a.toString().length()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (Exception e) {
                        System.err.println("Erro ao deletar: " + String.valueOf(path) + ": " + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            System.err.println("Erro ao deletar diret\u00f3rio: " + e.getMessage());
        }
        this.psbFolderRepository.delete(folderToDelete);
        List<PSBFolderEntity> foldersToReindex = this.psbFolderRepository.findByDamIdAndFolderIndexGreaterThanOrderByFolderIndexAsc(damId, deletedFolderIndex);
        for (PSBFolderEntity folder : foldersToReindex) {
            Integer oldIndex = folder.getFolderIndex();
            Integer newIndex = oldIndex - 1;
            String oldFolderPath = folder.getServerPath();
            String newFolderPath = this.createFolderPath(damId, newIndex, folder.getName());
            try {
                Path sourcePath = Paths.get(oldFolderPath, new String[0]);
                Path targetPath = Paths.get(newFolderPath, new String[0]);
                if (Files.exists(sourcePath, new LinkOption[0])) {
                    this.ensureDirectoryExists(targetPath.getParent().toString());
                    Files.move(sourcePath, targetPath, new CopyOption[0]);
                    folder.setServerPath(newFolderPath);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Erro ao reindexar pasta: " + e.getMessage(), e);
            }
            folder.setFolderIndex(newIndex);
            folder.setUpdatedAt(LocalDateTime.now());
            this.psbFolderRepository.save(folder);
        }
    }

    private String createFolderPath(Long damId, Integer folderIndex, String folderName) {
        String normalizedName = folderName.trim().toLowerCase().replace('\u00e7', 'c').replace('\u00e1', 'a').replace('\u00e0', 'a').replace('\u00e3', 'a').replace('\u00e2', 'a').replace('\u00e9', 'e').replace('\u00ea', 'e').replace('\u00ed', 'i').replace('\u00f3', 'o').replace('\u00f4', 'o').replace('\u00f5', 'o').replace('\u00fa', 'u').replaceAll("\\s+", "_").replaceAll("[^a-z0-9_]", "");
        return Paths.get(this.psbBaseDir, "dam-" + damId, String.format("%03d", folderIndex) + "-" + normalizedName).toString();
    }

    @Transactional
    public List<PSBFolderEntity> createMultipleFolders(DamEntity dam, List<PSBFolderCreationDTO> folderRequests, Long createdById) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getEditPSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para criar pastas PSB!");
        }
        UserEntity creator = (UserEntity)this.userRepository.findById(createdById).orElseThrow(() -> new NotFoundException("Usu\u00e1rio criador n\u00e3o encontrado"));
        ArrayList<PSBFolderEntity> createdFolders = new ArrayList<PSBFolderEntity>();
        for (PSBFolderCreationDTO folderDTO : folderRequests) {
            if (this.psbFolderRepository.existsByDamIdAndName(dam.getId(), folderDTO.getName())) {
                throw new DuplicateResourceException("J\u00e1 existe uma pasta com este nome nesta barragem: " + folderDTO.getName());
            }
            if (this.psbFolderRepository.existsByDamIdAndFolderIndex(dam.getId(), folderDTO.getFolderIndex())) {
                throw new DuplicateResourceException("J\u00e1 existe uma pasta com este \u00edndice nesta barragem: " + folderDTO.getFolderIndex());
            }
            String folderPath = this.createFolderPath(dam.getId(), folderDTO.getFolderIndex(), folderDTO.getName());
            this.ensureDirectoryExists(folderPath);
            PSBFolderEntity folder = new PSBFolderEntity();
            folder.setName(folderDTO.getName());
            folder.setFolderIndex(folderDTO.getFolderIndex());
            folder.setDescription(folderDTO.getDescription());
            folder.setDam(dam);
            folder.setServerPath(folderPath);
            folder.setCreatedBy(creator);
            folder.setColor(folderDTO.getColor());
            createdFolders.add((PSBFolderEntity)this.psbFolderRepository.save(folder));
        }
        return createdFolders;
    }

    private void ensureDirectoryExists(String dirPath) {
        File directory = new File(dirPath);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel criar o diret\u00f3rio: " + dirPath);
        }
    }

    @Generated
    public PSBFolderService(PSBFolderRepository psbFolderRepository, DamRepository damRepository, UserRepository userRepository) {
        this.psbFolderRepository = psbFolderRepository;
        this.damRepository = damRepository;
        this.userRepository = userRepository;
    }
}

