/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.permissions_main.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.infra.permissions.permissions_main.dtos.UserPermissionsDTO;
import com.geosegbar.infra.permissions.permissions_main.dtos.UserPermissionsUpdateDTO;
import com.geosegbar.infra.permissions.permissions_main.services.UserPermissionsService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user-permissions"})
public class UserPermissionsController {
    private final UserPermissionsService userPermissionsService;

    @GetMapping(value={"/user/{userId}"})
    public ResponseEntity<WebResponseEntity<UserPermissionsDTO>> getUserPermissions(@PathVariable Long userId) {
        UserPermissionsDTO permissions = this.userPermissionsService.getAllPermissionsForUser(userId);
        WebResponseEntity<UserPermissionsDTO> response = WebResponseEntity.success(permissions, "Permiss\u00f5es do usu\u00e1rio obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<WebResponseEntity<UserPermissionsDTO>> updateUserPermissions(@Valid @RequestBody UserPermissionsUpdateDTO updateDTO) {
        UserPermissionsDTO updatedPermissions = this.userPermissionsService.updateUserPermissions(updateDTO);
        WebResponseEntity<UserPermissionsDTO> response = WebResponseEntity.success(updatedPermissions, "Permiss\u00f5es do usu\u00e1rio atualizadas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/verify-checklist"})
    public ResponseEntity<WebResponseEntity<Object>> verifyChecklistPermission(@RequestParam Long userId, @RequestParam Long clientId, @RequestParam Long damId, @RequestParam Long checklistId, @RequestParam boolean isMobile) {
        String result = this.userPermissionsService.verifyChecklistPermission(userId, clientId, damId, checklistId, isMobile);
        if ("authorized".equals(result)) {
            WebResponseEntity<Boolean> response = WebResponseEntity.success(true, "Usu\u00e1rio autorizado a preencher o checklist");
            return ResponseEntity.ok(response);
        }
        WebResponseEntity response = WebResponseEntity.error(result);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(response);
    }

    @Generated
    public UserPermissionsController(UserPermissionsService userPermissionsService) {
        this.userPermissionsService = userPermissionsService;
    }
}

