/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.measurement_unit.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.MeasurementUnitEntity;
import com.geosegbar.infra.measurement_unit.services.MeasurementUnitService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/measurement-units"})
public class MeasurementUnitController {
    private final MeasurementUnitService measurementUnitService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<MeasurementUnitEntity>>> getAllMeasurementUnits() {
        List<MeasurementUnitEntity> units = this.measurementUnitService.findAll();
        return ResponseEntity.ok(WebResponseEntity.success(units, "Unidades de medida obtidas com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<MeasurementUnitEntity>> getMeasurementUnitById(@PathVariable Long id) {
        MeasurementUnitEntity unit = this.measurementUnitService.findById(id);
        return ResponseEntity.ok(WebResponseEntity.success(unit, "Unidade de medida obtida com sucesso!"));
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<MeasurementUnitEntity>> createMeasurementUnit(@Valid @RequestBody MeasurementUnitEntity measurementUnit) {
        MeasurementUnitEntity createdUnit = this.measurementUnitService.create(measurementUnit);
        return new ResponseEntity(WebResponseEntity.success(createdUnit, "Unidade de medida criada com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<MeasurementUnitEntity>> updateMeasurementUnit(@PathVariable Long id, @Valid @RequestBody MeasurementUnitEntity measurementUnit) {
        MeasurementUnitEntity updatedUnit = this.measurementUnitService.update(id, measurementUnit);
        return ResponseEntity.ok(WebResponseEntity.success(updatedUnit, "Unidade de medida atualizada com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteMeasurementUnit(@PathVariable Long id) {
        this.measurementUnitService.delete(id);
        return ResponseEntity.ok(WebResponseEntity.success(null, "Unidade de medida exclu\u00edda com sucesso!"));
    }

    @Generated
    public MeasurementUnitController(MeasurementUnitService measurementUnitService) {
        this.measurementUnitService = measurementUnitService;
    }
}

