/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_type.services;

import com.geosegbar.entities.InstrumentTypeEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.instrument_type.dtos.InstrumentTypeDTO;
import com.geosegbar.infra.instrument_type.persistence.jpa.InstrumentTypeRepository;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentTypeService {
    private final InstrumentTypeRepository instrumentTypeRepository;

    public List<InstrumentTypeDTO> findAll() {
        return this.instrumentTypeRepository.findAllByOrderByNameAsc().stream().map(this::mapToDTO).collect(Collectors.toList());
    }

    public InstrumentTypeDTO findById(Long id) {
        return this.mapToDTO(this.getEntityById(id));
    }

    public InstrumentTypeEntity getEntityById(Long id) {
        return (InstrumentTypeEntity)this.instrumentTypeRepository.findById(id).orElseThrow(() -> new NotFoundException("Tipo de instrumento n\u00e3o encontrado com ID: " + id));
    }

    @Transactional
    public InstrumentTypeDTO create(InstrumentTypeDTO dto) {
        if (this.instrumentTypeRepository.existsByName(dto.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe um tipo de instrumento com o nome: " + dto.getName());
        }
        InstrumentTypeEntity entity = new InstrumentTypeEntity();
        entity.setName(dto.getName().trim().toUpperCase());
        return this.mapToDTO((InstrumentTypeEntity)this.instrumentTypeRepository.save(entity));
    }

    @Transactional
    public InstrumentTypeDTO update(Long id, InstrumentTypeDTO dto) {
        InstrumentTypeEntity entity = this.getEntityById(id);
        if (this.instrumentTypeRepository.existsByName(dto.getName()) && !entity.getName().equalsIgnoreCase(dto.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe um tipo de instrumento com o nome: " + dto.getName());
        }
        entity.setName(dto.getName().trim().toUpperCase());
        return this.mapToDTO((InstrumentTypeEntity)this.instrumentTypeRepository.save(entity));
    }

    private InstrumentTypeDTO mapToDTO(InstrumentTypeEntity entity) {
        InstrumentTypeDTO dto = new InstrumentTypeDTO();
        dto.setId(entity.getId());
        dto.setName(entity.getName());
        return dto;
    }

    @Generated
    public InstrumentTypeService(InstrumentTypeRepository instrumentTypeRepository) {
        this.instrumentTypeRepository = instrumentTypeRepository;
    }
}

