/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_tabulate_pattern_folder.persistence.jpa;

import com.geosegbar.entities.InstrumentTabulatePatternFolder;
import jakarta.persistence.QueryHint;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstrumentTabulatePatternFolderRepository
extends JpaRepository<InstrumentTabulatePatternFolder, Long> {
    public Optional<InstrumentTabulatePatternFolder> findByName(String var1);

    public boolean existsByName(String var1);

    public boolean existsByNameAndDamId(String var1, Long var2);

    public List<InstrumentTabulatePatternFolder> findAllByOrderByNameAsc();

    public List<InstrumentTabulatePatternFolder> findByDamId(Long var1);

    public List<InstrumentTabulatePatternFolder> findByDamIdOrderByNameAsc(Long var1);

    @Query(value="SELECT f FROM InstrumentTabulatePatternFolder f WHERE f.name LIKE %:name%")
    public List<InstrumentTabulatePatternFolder> findByNameContaining(@Param(value="name") String var1);

    @Query(value="SELECT f FROM InstrumentTabulatePatternFolder f WHERE f.dam.id = :damId AND f.name LIKE %:name%")
    public List<InstrumentTabulatePatternFolder> findByDamIdAndNameContaining(@Param(value="damId") Long var1, @Param(value="name") String var2);

    @Query(value="SELECT DISTINCT f FROM InstrumentTabulatePatternFolder f JOIN f.patterns p JOIN p.associations a WHERE a.instrument.id = :instrumentId")
    public List<InstrumentTabulatePatternFolder> findByPatternInstrumentId(@Param(value="instrumentId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT f FROM InstrumentTabulatePatternFolder f LEFT JOIN FETCH f.dam d WHERE f.id = :folderId")
    public Optional<InstrumentTabulatePatternFolder> findByIdWithDam(@Param(value="folderId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT f FROM InstrumentTabulatePatternFolder f LEFT JOIN FETCH f.dam d WHERE f.dam.id = :damId ORDER BY f.name ASC")
    public List<InstrumentTabulatePatternFolder> findByDamIdWithDamDetails(@Param(value="damId") Long var1);
}

