/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist.services;

import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.entities.ChecklistEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.OptionEntity;
import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.entities.TemplateQuestionnaireEntity;
import com.geosegbar.entities.TemplateQuestionnaireQuestionEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.answer.persistence.jpa.AnswerRepository;
import com.geosegbar.infra.checklist.dtos.ChecklistWithLastAnswersAndDamDTO;
import com.geosegbar.infra.checklist.dtos.ChecklistWithLastAnswersDTO;
import com.geosegbar.infra.checklist.dtos.OptionDTO;
import com.geosegbar.infra.checklist.dtos.QuestionWithLastAnswerDTO;
import com.geosegbar.infra.checklist.dtos.TemplateQuestionnaireWithAnswersDTO;
import com.geosegbar.infra.checklist.persistence.jpa.ChecklistRepository;
import com.geosegbar.infra.dam.services.DamService;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ChecklistService {
    private final ChecklistRepository checklistRepository;
    private final DamService damService;
    private final AnswerRepository answerRepository;

    @Cacheable(value={"allChecklists"}, key="'all'", cacheManager="checklistCacheManager")
    public List<ChecklistEntity> findAll() {
        return this.checklistRepository.findAll();
    }

    @Cacheable(value={"checklistById"}, key="#id", cacheManager="checklistCacheManager")
    public ChecklistEntity findById(Long id) {
        return (ChecklistEntity)this.checklistRepository.findById(id).orElseThrow(() -> new NotFoundException("Checklist n\u00e3o encontrada para id: " + id));
    }

    @Transactional
    @CacheEvict(value={"allChecklists", "checklistById", "checklistsByDam", "checklistsWithAnswersByDam", "checklistsWithAnswersByClient", "checklistForDam"}, allEntries=true, cacheManager="checklistCacheManager")
    public ChecklistEntity save(ChecklistEntity checklist) {
        if (checklist.getDams() == null || checklist.getDams().isEmpty()) {
            throw new InvalidInputException("Checklist deve estar vinculado a uma barragem.");
        }
        if (checklist.getDams().size() > 1) {
            throw new InvalidInputException("Checklist s\u00f3 pode estar vinculado a uma \u00fanica barragem.");
        }
        Long damId = checklist.getDams().iterator().next().getId();
        if (this.checklistRepository.existsByNameAndDams_Id(checklist.getName(), damId)) {
            throw new DuplicateResourceException("J\u00e1 existe um checklist com esse nome para esta barragem.");
        }
        return (ChecklistEntity)this.checklistRepository.save(checklist);
    }

    @Transactional
    @Cacheable(value={"checklistsWithAnswersByDam"}, key="#damId", cacheManager="checklistCacheManager")
    public List<ChecklistWithLastAnswersDTO> findChecklistsWithLastAnswersForDam(Long damId) {
        this.damService.findById(damId);
        List<ChecklistEntity> checklists = this.checklistRepository.findByDamIdWithFullDetails(damId);
        ArrayList<ChecklistWithLastAnswersDTO> result = new ArrayList<ChecklistWithLastAnswersDTO>();
        for (ChecklistEntity checklist : checklists) {
            ChecklistWithLastAnswersDTO checklistDTO = new ChecklistWithLastAnswersDTO();
            checklistDTO.setId(checklist.getId());
            checklistDTO.setName(checklist.getName());
            checklistDTO.setCreatedAt(checklist.getCreatedAt());
            ArrayList<TemplateQuestionnaireWithAnswersDTO> templateDTOs = new ArrayList<TemplateQuestionnaireWithAnswersDTO>();
            for (TemplateQuestionnaireEntity template : checklist.getTemplateQuestionnaires()) {
                TemplateQuestionnaireWithAnswersDTO templateDTO = new TemplateQuestionnaireWithAnswersDTO();
                templateDTO.setId(template.getId());
                templateDTO.setName(template.getName());
                ArrayList<QuestionWithLastAnswerDTO> questionDTOs = new ArrayList<QuestionWithLastAnswerDTO>();
                for (TemplateQuestionnaireQuestionEntity tqQuestion : template.getTemplateQuestions()) {
                    QuestionEntity question = tqQuestion.getQuestion();
                    QuestionWithLastAnswerDTO questionDTO = new QuestionWithLastAnswerDTO();
                    questionDTO.setId(question.getId());
                    questionDTO.setQuestionText(question.getQuestionText());
                    questionDTO.setType(question.getType());
                    List<OptionDTO> allOptionDTOs = question.getOptions().stream().map(opt -> new OptionDTO(opt.getId(), opt.getLabel(), opt.getValue())).collect(Collectors.toList());
                    questionDTO.setAllOptions(allOptionDTOs);
                    Optional<AnswerEntity> lastNonNIAnswer = this.answerRepository.findLatestNonNIAnswer(damId, question.getId(), template.getId());
                    lastNonNIAnswer.ifPresent(answer -> {
                        Optional<OptionEntity> nonNIOption = answer.getSelectedOptions().stream().filter(opt -> !"NI".equalsIgnoreCase(opt.getLabel())).findFirst();
                        nonNIOption.ifPresent(option -> {
                            OptionDTO optionDTO = new OptionDTO(option.getId(), option.getLabel(), option.getValue());
                            questionDTO.setLastSelectedOption(optionDTO);
                            questionDTO.setAnswerResponseId(answer.getId());
                        });
                    });
                    questionDTOs.add(questionDTO);
                }
                templateDTO.setQuestions(questionDTOs);
                templateDTOs.add(templateDTO);
            }
            checklistDTO.setTemplateQuestionnaires(templateDTOs);
            result.add(checklistDTO);
        }
        return result;
    }

    @Transactional
    @Cacheable(value={"checklistsWithAnswersByClient"}, key="#clientId", cacheManager="checklistCacheManager")
    public List<ChecklistWithLastAnswersAndDamDTO> findAllChecklistsWithLastAnswersByClientId(Long clientId) {
        List<DamEntity> clientDams = this.damService.findDamsByClientId(clientId);
        ArrayList<ChecklistWithLastAnswersAndDamDTO> allChecklists = new ArrayList<ChecklistWithLastAnswersAndDamDTO>();
        for (DamEntity dam : clientDams) {
            List<ChecklistEntity> damChecklists = this.checklistRepository.findByDamIdWithFullDetails(dam.getId());
            for (ChecklistEntity checklist : damChecklists) {
                ChecklistWithLastAnswersAndDamDTO checklistDTO = new ChecklistWithLastAnswersAndDamDTO();
                checklistDTO.setId(checklist.getId());
                checklistDTO.setName(checklist.getName());
                checklistDTO.setCreatedAt(checklist.getCreatedAt());
                ChecklistWithLastAnswersAndDamDTO.DamInfoDTO damInfo = new ChecklistWithLastAnswersAndDamDTO.DamInfoDTO(dam.getId(), dam.getName(), dam.getCity(), dam.getState(), dam.getLatitude(), dam.getLongitude());
                checklistDTO.setDam(damInfo);
                ArrayList<TemplateQuestionnaireWithAnswersDTO> templateDTOs = new ArrayList<TemplateQuestionnaireWithAnswersDTO>();
                for (TemplateQuestionnaireEntity template : checklist.getTemplateQuestionnaires()) {
                    TemplateQuestionnaireWithAnswersDTO templateDTO = new TemplateQuestionnaireWithAnswersDTO();
                    templateDTO.setId(template.getId());
                    templateDTO.setName(template.getName());
                    ArrayList<QuestionWithLastAnswerDTO> questionDTOs = new ArrayList<QuestionWithLastAnswerDTO>();
                    for (TemplateQuestionnaireQuestionEntity tqQuestion : template.getTemplateQuestions()) {
                        QuestionEntity question = tqQuestion.getQuestion();
                        QuestionWithLastAnswerDTO questionDTO = new QuestionWithLastAnswerDTO();
                        questionDTO.setId(question.getId());
                        questionDTO.setQuestionText(question.getQuestionText());
                        questionDTO.setType(question.getType());
                        List<OptionDTO> allOptionDTOs = question.getOptions().stream().map(opt -> new OptionDTO(opt.getId(), opt.getLabel(), opt.getValue())).collect(Collectors.toList());
                        questionDTO.setAllOptions(allOptionDTOs);
                        Optional<AnswerEntity> lastNonNIAnswer = this.answerRepository.findLatestNonNIAnswer(dam.getId(), question.getId(), template.getId());
                        lastNonNIAnswer.ifPresent(answer -> {
                            Optional<OptionEntity> nonNIOption = answer.getSelectedOptions().stream().filter(opt -> !"NI".equalsIgnoreCase(opt.getLabel())).findFirst();
                            nonNIOption.ifPresent(option -> {
                                OptionDTO optionDTO = new OptionDTO(option.getId(), option.getLabel(), option.getValue());
                                questionDTO.setLastSelectedOption(optionDTO);
                                questionDTO.setAnswerResponseId(answer.getId());
                            });
                        });
                        questionDTOs.add(questionDTO);
                    }
                    templateDTO.setQuestions(questionDTOs);
                    templateDTOs.add(templateDTO);
                }
                checklistDTO.setTemplateQuestionnaires(templateDTOs);
                allChecklists.add(checklistDTO);
            }
        }
        allChecklists.sort((a, b) -> {
            int damComparison = a.getDam().getName().compareTo(b.getDam().getName());
            return damComparison != 0 ? damComparison : a.getName().compareTo(b.getName());
        });
        return allChecklists;
    }

    @Transactional
    @CacheEvict(value={"allChecklists", "checklistById", "checklistsByDam", "checklistsWithAnswersByDam", "checklistsWithAnswersByClient", "checklistForDam"}, allEntries=true, cacheManager="checklistCacheManager")
    public ChecklistEntity update(ChecklistEntity checklist) {
        if (checklist.getDams() == null || checklist.getDams().isEmpty()) {
            throw new InvalidInputException("Checklist deve estar vinculado a uma barragem.");
        }
        if (checklist.getDams().size() > 1) {
            throw new InvalidInputException("Checklist s\u00f3 pode estar vinculado a uma \u00fanica barragem.");
        }
        Long damId = checklist.getDams().iterator().next().getId();
        if (this.checklistRepository.existsByNameAndDams_IdAndIdNot(checklist.getName(), damId, checklist.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um checklist com esse nome para esta barragem.");
        }
        return (ChecklistEntity)this.checklistRepository.save(checklist);
    }

    @Transactional
    @CacheEvict(value={"allChecklists", "checklistById", "checklistsByDam", "checklistsWithAnswersByDam", "checklistsWithAnswersByClient", "checklistForDam"}, allEntries=true, cacheManager="checklistCacheManager")
    public void deleteById(Long id) {
        this.checklistRepository.findById(id).orElseThrow(() -> new NotFoundException("Checklist n\u00e3o encontrada para exclus\u00e3o!"));
        this.checklistRepository.deleteById(id);
    }

    @Cacheable(value={"checklistsByDam"}, key="#damId", cacheManager="checklistCacheManager")
    public List<ChecklistEntity> findByDamId(Long damId) {
        return this.checklistRepository.findByDams_Id(damId);
    }

    @Cacheable(value={"checklistForDam"}, key="#damId + '_' + #checklistId", cacheManager="checklistCacheManager")
    public ChecklistEntity findChecklistForDam(Long damId, Long checklistId) {
        ChecklistEntity checklist = this.findById(checklistId);
        if (checklist.getDams().stream().anyMatch(dam -> dam.getId().equals(damId))) {
            return checklist;
        }
        throw new NotFoundException("O checklist n\u00e3o pertence \u00e0 barragem especificada!");
    }

    @Generated
    public ChecklistService(ChecklistRepository checklistRepository, DamService damService, AnswerRepository answerRepository) {
        this.checklistRepository = checklistRepository;
        this.damService = damService;
        this.answerRepository = answerRepository;
    }
}

