/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.entities.ConstantEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.InputEntity;
import com.geosegbar.entities.InstrumentTypeEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.entities.ReadingEntity;
import com.geosegbar.entities.SectionEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="instrument", indexes={@Index(name="idx_instrument_dam_active", columnList="dam_id, active"), @Index(name="idx_instrument_section_active", columnList="section_id, active"), @Index(name="idx_instrument_name", columnList="name"), @Index(name="idx_instrument_active_section", columnList="active, activeForSection"), @Index(name="idx_instrument_type_active", columnList="instrument_type_id, active"), @Index(name="idx_instrument_dam_type", columnList="dam_id, instrument_type_id"), @Index(name="idx_instrument_coordinates", columnList="latitude, longitude"), @Index(name="idx_instrument_dam_coordinates", columnList="dam_id, latitude, longitude"), @Index(name="idx_instrument_dam_section", columnList="dam_id, section_id"), @Index(name="idx_instrument_linimetric", columnList="is_linimetric_ruler")})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class InstrumentEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Nome do Instrumento \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="Nome do Instrumento \u00e9 obrigat\u00f3rio!") String name;
    @Column(nullable=true)
    private String location;
    @Column(nullable=true)
    private Double distanceOffset;
    @NotNull(message="Latitude do Instrumento \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotNull(message="Latitude do Instrumento \u00e9 obrigat\u00f3rio!") Double latitude;
    @NotNull(message="Longitude do Instrumento \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotNull(message="Longitude do Instrumento \u00e9 obrigat\u00f3rio!") Double longitude;
    @NotNull(message="Campo 'Sem limites' do Instrumento \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotNull(message="Campo 'Sem limites' do Instrumento \u00e9 obrigat\u00f3rio!") Boolean noLimit;
    @ManyToOne
    @JoinColumn(name="dam_id", nullable=false)
    @JsonIgnoreProperties(value={"instruments"})
    private DamEntity dam;
    @ManyToOne
    @JoinColumn(name="instrument_type_id", nullable=false)
    private InstrumentTypeEntity instrumentType;
    @NotNull(message="Campo 'Ativo' do Instrumento \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotNull(message="Campo 'Ativo' do Instrumento \u00e9 obrigat\u00f3rio!") Boolean active;
    @Column(nullable=false)
    private Boolean activeForSection = true;
    @Column(nullable=false)
    private LocalDateTime lastUpdateVariablesDate;
    @Column(name="is_linimetric_ruler", nullable=false)
    private Boolean isLinimetricRuler;
    @Column(name="linimetric_ruler_code", nullable=true)
    private Long linimetricRulerCode;
    @ManyToOne
    @JoinColumn(name="section_id", nullable=true)
    private SectionEntity section;
    @OneToMany(mappedBy="instrument", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"instrument"})
    private Set<InputEntity> inputs = new HashSet<InputEntity>();
    @OneToMany(mappedBy="instrument", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"instrument"})
    private Set<ConstantEntity> constants = new HashSet<ConstantEntity>();
    @OneToMany(mappedBy="instrument", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"instrument"})
    private Set<OutputEntity> outputs = new HashSet<OutputEntity>();
    @OneToMany(mappedBy="instrument", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"instrument"})
    private Set<ReadingEntity> readings = new HashSet<ReadingEntity>();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public Double getDistanceOffset() {
        return this.distanceOffset;
    }

    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Generated
    public Boolean getNoLimit() {
        return this.noLimit;
    }

    @Generated
    public DamEntity getDam() {
        return this.dam;
    }

    @Generated
    public InstrumentTypeEntity getInstrumentType() {
        return this.instrumentType;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Boolean getActiveForSection() {
        return this.activeForSection;
    }

    @Generated
    public LocalDateTime getLastUpdateVariablesDate() {
        return this.lastUpdateVariablesDate;
    }

    @Generated
    public Boolean getIsLinimetricRuler() {
        return this.isLinimetricRuler;
    }

    @Generated
    public Long getLinimetricRulerCode() {
        return this.linimetricRulerCode;
    }

    @Generated
    public SectionEntity getSection() {
        return this.section;
    }

    @Generated
    public Set<InputEntity> getInputs() {
        return this.inputs;
    }

    @Generated
    public Set<ConstantEntity> getConstants() {
        return this.constants;
    }

    @Generated
    public Set<OutputEntity> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Set<ReadingEntity> getReadings() {
        return this.readings;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setDistanceOffset(Double distanceOffset) {
        this.distanceOffset = distanceOffset;
    }

    @Generated
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setNoLimit(Boolean noLimit) {
        this.noLimit = noLimit;
    }

    @JsonIgnoreProperties(value={"instruments"})
    @Generated
    public void setDam(DamEntity dam) {
        this.dam = dam;
    }

    @Generated
    public void setInstrumentType(InstrumentTypeEntity instrumentType) {
        this.instrumentType = instrumentType;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setActiveForSection(Boolean activeForSection) {
        this.activeForSection = activeForSection;
    }

    @Generated
    public void setLastUpdateVariablesDate(LocalDateTime lastUpdateVariablesDate) {
        this.lastUpdateVariablesDate = lastUpdateVariablesDate;
    }

    @Generated
    public void setIsLinimetricRuler(Boolean isLinimetricRuler) {
        this.isLinimetricRuler = isLinimetricRuler;
    }

    @Generated
    public void setLinimetricRulerCode(Long linimetricRulerCode) {
        this.linimetricRulerCode = linimetricRulerCode;
    }

    @Generated
    public void setSection(SectionEntity section) {
        this.section = section;
    }

    @JsonIgnoreProperties(value={"instrument"})
    @Generated
    public void setInputs(Set<InputEntity> inputs) {
        this.inputs = inputs;
    }

    @JsonIgnoreProperties(value={"instrument"})
    @Generated
    public void setConstants(Set<ConstantEntity> constants) {
        this.constants = constants;
    }

    @JsonIgnoreProperties(value={"instrument"})
    @Generated
    public void setOutputs(Set<OutputEntity> outputs) {
        this.outputs = outputs;
    }

    @JsonIgnoreProperties(value={"instrument"})
    @Generated
    public void setReadings(Set<ReadingEntity> readings) {
        this.readings = readings;
    }

    @Generated
    public InstrumentEntity() {
    }

    @Generated
    public InstrumentEntity(Long id, String name, String location, Double distanceOffset, Double latitude, Double longitude, Boolean noLimit, DamEntity dam, InstrumentTypeEntity instrumentType, Boolean active, Boolean activeForSection, LocalDateTime lastUpdateVariablesDate, Boolean isLinimetricRuler, Long linimetricRulerCode, SectionEntity section, Set<InputEntity> inputs, Set<ConstantEntity> constants, Set<OutputEntity> outputs, Set<ReadingEntity> readings) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.distanceOffset = distanceOffset;
        this.latitude = latitude;
        this.longitude = longitude;
        this.noLimit = noLimit;
        this.dam = dam;
        this.instrumentType = instrumentType;
        this.active = active;
        this.activeForSection = activeForSection;
        this.lastUpdateVariablesDate = lastUpdateVariablesDate;
        this.isLinimetricRuler = isLinimetricRuler;
        this.linimetricRulerCode = linimetricRulerCode;
        this.section = section;
        this.inputs = inputs;
        this.constants = constants;
        this.outputs = outputs;
        this.readings = readings;
    }
}

