/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.entities.ChecklistEntity;
import com.geosegbar.entities.ChecklistResponseEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamPermissionEntity;
import com.geosegbar.entities.DocumentationDamEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.InstrumentGraphPatternFolder;
import com.geosegbar.entities.PSBFolderEntity;
import com.geosegbar.entities.RegulatoryDamEntity;
import com.geosegbar.entities.ReservoirEntity;
import com.geosegbar.entities.SectionEntity;
import com.geosegbar.entities.StatusEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="dam", indexes={@Index(name="idx_dam_client_id", columnList="client_id"), @Index(name="idx_dam_status_id", columnList="status_id"), @Index(name="idx_dam_name", columnList="name"), @Index(name="idx_dam_coords", columnList="latitude, longitude"), @Index(name="idx_dam_city_state", columnList="city, state"), @Index(name="idx_dam_zip", columnList="zip_code"), @Index(name="idx_dam_latitude", columnList="latitude"), @Index(name="idx_dam_longitude", columnList="longitude"), @Index(name="idx_dam_city", columnList="city"), @Index(name="idx_dam_state", columnList="state"), @Index(name="idx_dam_client_status", columnList="client_id, status_id"), @Index(name="idx_dam_client_name", columnList="client_id, name"), @Index(name="idx_dam_status_city", columnList="status_id, city"), @Index(name="idx_dam_client_coords", columnList="client_id, latitude, longitude"), @Index(name="idx_dam_client_geo_status", columnList="client_id, status_id, latitude, longitude")})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class DamEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="O campo n\u00e3o pode conter n\u00fameros!")
    @Column(nullable=false)
    private @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="O campo n\u00e3o pode conter n\u00fameros!") String name;
    @Column(nullable=false)
    @NotNull(message="Latitude \u00e9 obrigat\u00f3rio!")
    private @NotNull(message="Latitude \u00e9 obrigat\u00f3rio!") Double latitude;
    @Column(nullable=false)
    @NotNull(message="Longitude \u00e9 obrigat\u00f3rio!")
    private @NotNull(message="Longitude \u00e9 obrigat\u00f3rio!") Double longitude;
    @NotBlank(message="O nome da rua \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="O nome da rua \u00e9 obrigat\u00f3rio!") String street;
    @NotBlank(message="O nome do bairro \u00e9 obrigat\u00f3rio!")
    @Size(max=100, message="O nome do bairro deve ter no m\u00e1ximo 100 caracteres!")
    @Column(nullable=false, length=100)
    private @NotBlank(message="O nome do bairro \u00e9 obrigat\u00f3rio!") @Size(max=100, message="O nome do bairro deve ter no m\u00e1ximo 100 caracteres!") String neighborhood;
    @Pattern(regexp="^[0-9]+$", message="O n\u00famero do endere\u00e7o deve conter apenas n\u00fameros!")
    @Size(max=10, message="O n\u00famero do endere\u00e7o deve ter no m\u00e1ximo 10 caracteres!")
    @Column(length=10)
    private @Pattern(regexp="^[0-9]+$", message="O n\u00famero do endere\u00e7o deve conter apenas n\u00fameros!") @Size(max=10, message="O n\u00famero do endere\u00e7o deve ter no m\u00e1ximo 10 caracteres!") String numberAddress;
    @NotBlank(message="O nome da cidade \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Cidade n\u00e3o pode conter n\u00fameros!")
    @Size(max=100, message="O nome da cidade deve ter no m\u00e1ximo 100 caracteres!")
    @Column(nullable=false, length=100)
    private @NotBlank(message="O nome da cidade \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Cidade n\u00e3o pode conter n\u00fameros!") @Size(max=100, message="O nome da cidade deve ter no m\u00e1ximo 100 caracteres!") String city;
    @NotBlank(message="O nome do estado \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Estado n\u00e3o pode conter n\u00fameros!")
    @Size(max=100, message="O nome do estado deve ter no m\u00e1ximo 100 caracteres!")
    @Column(nullable=false, length=100)
    private @NotBlank(message="O nome do estado \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Estado n\u00e3o pode conter n\u00fameros!") @Size(max=100, message="O nome do estado deve ter no m\u00e1ximo 100 caracteres!") String state;
    @NotBlank(message="CEP \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^\\d{5}-?\\d{3}$", message="CEP inv\u00e1lido!")
    @Column(nullable=false, length=9)
    private @NotBlank(message="CEP \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^\\d{5}-?\\d{3}$", message="CEP inv\u00e1lido!") String zipCode;
    @ManyToOne
    @JoinColumn(name="client_id")
    private ClientEntity client;
    @ManyToOne
    @JoinColumn(name="status_id")
    private StatusEntity status;
    @Column(nullable=true)
    private String logoPath;
    @Column(nullable=true)
    private String damImagePath;
    @Column(nullable=true)
    private String linkPSB;
    @Column(nullable=true)
    private String linkLegislation;
    @OneToOne(mappedBy="dam", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"dam"})
    private RegulatoryDamEntity regulatoryDam;
    @OneToOne(mappedBy="dam", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"dam"})
    private DocumentationDamEntity documentationDam;
    @ManyToMany(mappedBy="dams", fetch=FetchType.LAZY)
    @JsonIgnore
    private Set<ChecklistEntity> checklists = new HashSet<ChecklistEntity>();
    @OneToMany(mappedBy="dam", fetch=FetchType.LAZY)
    @JsonIgnore
    private Set<ChecklistResponseEntity> checklistResponses = new HashSet<ChecklistResponseEntity>();
    @OneToMany(mappedBy="dam", cascade={CascadeType.ALL}, orphanRemoval=false, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"dam"})
    private Set<SectionEntity> sections = new HashSet<SectionEntity>();
    @JsonIgnore
    @OneToMany(mappedBy="dam", fetch=FetchType.LAZY)
    private Set<DamPermissionEntity> damPermissions = new HashSet<DamPermissionEntity>();
    @OneToMany(mappedBy="dam", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"dam"})
    private Set<ReservoirEntity> reservoirs = new HashSet<ReservoirEntity>();
    @OneToMany(mappedBy="dam", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"dam"})
    private Set<PSBFolderEntity> psbFolders = new HashSet<PSBFolderEntity>();
    @OneToMany(mappedBy="dam", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"dam"})
    private Set<InstrumentEntity> instruments = new HashSet<InstrumentEntity>();
    @OneToMany(mappedBy="dam", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"dam"})
    private Set<InstrumentGraphPatternFolder> patternFolders = new HashSet<InstrumentGraphPatternFolder>();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @Generated
    public String getNeighborhood() {
        return this.neighborhood;
    }

    @Generated
    public String getNumberAddress() {
        return this.numberAddress;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getZipCode() {
        return this.zipCode;
    }

    @Generated
    public ClientEntity getClient() {
        return this.client;
    }

    @Generated
    public StatusEntity getStatus() {
        return this.status;
    }

    @Generated
    public String getLogoPath() {
        return this.logoPath;
    }

    @Generated
    public String getDamImagePath() {
        return this.damImagePath;
    }

    @Generated
    public String getLinkPSB() {
        return this.linkPSB;
    }

    @Generated
    public String getLinkLegislation() {
        return this.linkLegislation;
    }

    @Generated
    public RegulatoryDamEntity getRegulatoryDam() {
        return this.regulatoryDam;
    }

    @Generated
    public DocumentationDamEntity getDocumentationDam() {
        return this.documentationDam;
    }

    @Generated
    public Set<ChecklistEntity> getChecklists() {
        return this.checklists;
    }

    @Generated
    public Set<ChecklistResponseEntity> getChecklistResponses() {
        return this.checklistResponses;
    }

    @Generated
    public Set<SectionEntity> getSections() {
        return this.sections;
    }

    @Generated
    public Set<DamPermissionEntity> getDamPermissions() {
        return this.damPermissions;
    }

    @Generated
    public Set<ReservoirEntity> getReservoirs() {
        return this.reservoirs;
    }

    @Generated
    public Set<PSBFolderEntity> getPsbFolders() {
        return this.psbFolders;
    }

    @Generated
    public Set<InstrumentEntity> getInstruments() {
        return this.instruments;
    }

    @Generated
    public Set<InstrumentGraphPatternFolder> getPatternFolders() {
        return this.patternFolders;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setStreet(String street) {
        this.street = street;
    }

    @Generated
    public void setNeighborhood(String neighborhood) {
        this.neighborhood = neighborhood;
    }

    @Generated
    public void setNumberAddress(String numberAddress) {
        this.numberAddress = numberAddress;
    }

    @Generated
    public void setCity(String city) {
        this.city = city;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Generated
    public void setClient(ClientEntity client) {
        this.client = client;
    }

    @Generated
    public void setStatus(StatusEntity status) {
        this.status = status;
    }

    @Generated
    public void setLogoPath(String logoPath) {
        this.logoPath = logoPath;
    }

    @Generated
    public void setDamImagePath(String damImagePath) {
        this.damImagePath = damImagePath;
    }

    @Generated
    public void setLinkPSB(String linkPSB) {
        this.linkPSB = linkPSB;
    }

    @Generated
    public void setLinkLegislation(String linkLegislation) {
        this.linkLegislation = linkLegislation;
    }

    @JsonIgnoreProperties(value={"dam"})
    @Generated
    public void setRegulatoryDam(RegulatoryDamEntity regulatoryDam) {
        this.regulatoryDam = regulatoryDam;
    }

    @JsonIgnoreProperties(value={"dam"})
    @Generated
    public void setDocumentationDam(DocumentationDamEntity documentationDam) {
        this.documentationDam = documentationDam;
    }

    @JsonIgnore
    @Generated
    public void setChecklists(Set<ChecklistEntity> checklists) {
        this.checklists = checklists;
    }

    @JsonIgnore
    @Generated
    public void setChecklistResponses(Set<ChecklistResponseEntity> checklistResponses) {
        this.checklistResponses = checklistResponses;
    }

    @JsonIgnoreProperties(value={"dam"})
    @Generated
    public void setSections(Set<SectionEntity> sections) {
        this.sections = sections;
    }

    @JsonIgnore
    @Generated
    public void setDamPermissions(Set<DamPermissionEntity> damPermissions) {
        this.damPermissions = damPermissions;
    }

    @JsonIgnoreProperties(value={"dam"})
    @Generated
    public void setReservoirs(Set<ReservoirEntity> reservoirs) {
        this.reservoirs = reservoirs;
    }

    @JsonIgnoreProperties(value={"dam"})
    @Generated
    public void setPsbFolders(Set<PSBFolderEntity> psbFolders) {
        this.psbFolders = psbFolders;
    }

    @JsonIgnoreProperties(value={"dam"})
    @Generated
    public void setInstruments(Set<InstrumentEntity> instruments) {
        this.instruments = instruments;
    }

    @JsonIgnoreProperties(value={"dam"})
    @Generated
    public void setPatternFolders(Set<InstrumentGraphPatternFolder> patternFolders) {
        this.patternFolders = patternFolders;
    }

    @Generated
    public DamEntity() {
    }

    @Generated
    public DamEntity(Long id, String name, Double latitude, Double longitude, String street, String neighborhood, String numberAddress, String city, String state, String zipCode, ClientEntity client, StatusEntity status, String logoPath, String damImagePath, String linkPSB, String linkLegislation, RegulatoryDamEntity regulatoryDam, DocumentationDamEntity documentationDam, Set<ChecklistEntity> checklists, Set<ChecklistResponseEntity> checklistResponses, Set<SectionEntity> sections, Set<DamPermissionEntity> damPermissions, Set<ReservoirEntity> reservoirs, Set<PSBFolderEntity> psbFolders, Set<InstrumentEntity> instruments, Set<InstrumentGraphPatternFolder> patternFolders) {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.street = street;
        this.neighborhood = neighborhood;
        this.numberAddress = numberAddress;
        this.city = city;
        this.state = state;
        this.zipCode = zipCode;
        this.client = client;
        this.status = status;
        this.logoPath = logoPath;
        this.damImagePath = damImagePath;
        this.linkPSB = linkPSB;
        this.linkLegislation = linkLegislation;
        this.regulatoryDam = regulatoryDam;
        this.documentationDam = documentationDam;
        this.checklists = checklists;
        this.checklistResponses = checklistResponses;
        this.sections = sections;
        this.damPermissions = damPermissions;
        this.reservoirs = reservoirs;
        this.psbFolders = psbFolders;
        this.instruments = instruments;
        this.patternFolders = patternFolders;
    }
}

