/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.statistical_limit.services;

import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.entities.StatisticalLimitEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.output.persistence.jpa.OutputRepository;
import com.geosegbar.infra.statistical_limit.persistence.jpa.StatisticalLimitRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StatisticalLimitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticalLimitService.class);
    private final StatisticalLimitRepository statisticalLimitRepository;
    private final OutputRepository outputRepository;

    public Optional<StatisticalLimitEntity> findByOutputId(Long outputId) {
        return this.statisticalLimitRepository.findByOutputId(outputId);
    }

    public List<Long> findStatisticalLimitIdsByOutputInstrumentDamId(Long damId) {
        return this.statisticalLimitRepository.findLimitIdsByOutputInstrumentDamId(damId);
    }

    public StatisticalLimitEntity findById(Long id) {
        return (StatisticalLimitEntity)this.statisticalLimitRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Limite estat\u00edstico n\u00e3o encontrado com ID: " + id));
    }

    @Transactional
    public StatisticalLimitEntity createOrUpdate(Long outputId, StatisticalLimitEntity limit) {
        OutputEntity output = (OutputEntity)this.outputRepository.findById((Object)outputId).orElseThrow(() -> new NotFoundException("Output n\u00e3o encontrado com ID: " + outputId));
        InstrumentEntity instrument = output.getInstrument();
        if (instrument == null) {
            throw new IllegalStateException("Output sem instrumento associado");
        }
        if (Boolean.TRUE.equals(instrument.getNoLimit())) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel adicionar limites a um output de um instrumento marcado como 'Sem Limites'");
        }
        if (output.getDeterministicLimit() != null) {
            throw new IllegalStateException("Este output j\u00e1 possui limite determin\u00edstico. N\u00e3o \u00e9 poss\u00edvel ter ambos os tipos de limite");
        }
        Optional existingLimit = this.statisticalLimitRepository.findByOutputId(outputId);
        if (existingLimit.isPresent()) {
            StatisticalLimitEntity existingEntity = (StatisticalLimitEntity)existingLimit.get();
            existingEntity.setLowerValue(limit.getLowerValue());
            existingEntity.setUpperValue(limit.getUpperValue());
            return (StatisticalLimitEntity)this.statisticalLimitRepository.save((Object)existingEntity);
        }
        limit.setOutput(output);
        StatisticalLimitEntity savedLimit = (StatisticalLimitEntity)this.statisticalLimitRepository.save((Object)limit);
        output.setStatisticalLimit(savedLimit);
        this.outputRepository.save((Object)output);
        return savedLimit;
    }

    @Transactional
    public void deleteById(Long id) {
        StatisticalLimitEntity limit = this.findById(id);
        OutputEntity output = limit.getOutput();
        if (output != null) {
            output.setStatisticalLimit(null);
            this.outputRepository.save((Object)output);
        }
        this.statisticalLimitRepository.delete((Object)limit);
        log.info("Limite estat\u00edstico exclu\u00eddo para o output ID: {}", output != null ? output.getId() : "desconhecido");
    }

    @Generated
    public StatisticalLimitService(StatisticalLimitRepository statisticalLimitRepository, OutputRepository outputRepository) {
        this.statisticalLimitRepository = statisticalLimitRepository;
        this.outputRepository = outputRepository;
    }
}

