/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.security_level.services;

import com.geosegbar.entities.SecurityLevelEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.security_level.persistence.SecurityLevelRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SecurityLevelService {
    private final SecurityLevelRepository securityLevelRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultSecurityLevels() {
        this.createIfNotExists("Normal");
        this.createIfNotExists("Aten\u00e7\u00e3o");
        this.createIfNotExists("Alerta");
        this.createIfNotExists("Emerg\u00eancia");
    }

    private void createIfNotExists(String level) {
        if (!this.securityLevelRepository.existsByLevel(level)) {
            SecurityLevelEntity securityLevel = new SecurityLevelEntity();
            securityLevel.setLevel(level);
            this.securityLevelRepository.save((Object)securityLevel);
        }
    }

    @Transactional
    public void deleteById(Long id) {
        this.securityLevelRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("N\u00edvel de seguran\u00e7a n\u00e3o encontrado para exclus\u00e3o!"));
        this.securityLevelRepository.deleteById((Object)id);
    }

    @Transactional
    public SecurityLevelEntity save(SecurityLevelEntity securityLevelEntity) {
        if (this.securityLevelRepository.existsByLevel(securityLevelEntity.getLevel())) {
            throw new DuplicateResourceException("J\u00e1 existe um n\u00edvel de seguran\u00e7a com este nome!");
        }
        return (SecurityLevelEntity)this.securityLevelRepository.save((Object)securityLevelEntity);
    }

    @Transactional
    public SecurityLevelEntity update(SecurityLevelEntity securityLevelEntity) {
        this.securityLevelRepository.findById((Object)securityLevelEntity.getId()).orElseThrow(() -> new NotFoundException("N\u00edvel de seguran\u00e7a n\u00e3o encontrado para atualiza\u00e7\u00e3o!"));
        if (this.securityLevelRepository.existsByLevelAndIdNot(securityLevelEntity.getLevel(), securityLevelEntity.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um n\u00edvel de seguran\u00e7a com este nome!");
        }
        return (SecurityLevelEntity)this.securityLevelRepository.save((Object)securityLevelEntity);
    }

    public SecurityLevelEntity findById(Long id) {
        return (SecurityLevelEntity)this.securityLevelRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("N\u00edvel de seguran\u00e7a n\u00e3o encontrado!"));
    }

    public List<SecurityLevelEntity> findAll() {
        return this.securityLevelRepository.findAllByOrderByIdAsc();
    }

    @Generated
    public SecurityLevelService(SecurityLevelRepository securityLevelRepository) {
        this.securityLevelRepository = securityLevelRepository;
    }
}

