/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.section.services;

import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.entities.SectionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.BusinessRuleException;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.UnauthorizedException;
import com.geosegbar.infra.file_storage.FileStorageService;
import com.geosegbar.infra.section.dtos.CreateSectionDTO;
import com.geosegbar.infra.section.persistence.jpa.SectionRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SectionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SectionService.class);
    private final SectionRepository sectionRepository;
    private final FileStorageService fileStorageService;

    public List<SectionEntity> findAll() {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a visualizar se\u00e7\u00f5es!");
        }
        List sections = this.sectionRepository.findAllByOrderByNameAsc();
        sections.forEach(section -> {
            if (section.getDam() != null) {
                Hibernate.initialize((Object)section.getDam());
            }
        });
        return sections;
    }

    public SectionEntity findById(Long id) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a visualizar se\u00e7\u00f5es!");
        }
        SectionEntity section = (SectionEntity)this.sectionRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Se\u00e7\u00e3o n\u00e3o encontrada com ID: " + id));
        if (section.getDam() != null) {
            Hibernate.initialize((Object)section.getDam());
        }
        return section;
    }

    public List<SectionEntity> findAllByDamId(Long damId) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a visualizar se\u00e7\u00f5es!");
        }
        List sections = this.sectionRepository.findAllByDamId(damId);
        sections.forEach(section -> {
            if (section.getDam() != null) {
                Hibernate.initialize((Object)section.getDam());
            }
        });
        return sections;
    }

    public Optional<SectionEntity> findByName(String name) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a visualizar se\u00e7\u00f5es!");
        }
        return this.sectionRepository.findByName(name);
    }

    @Transactional
    public SectionEntity create(SectionEntity section) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getEditSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a criar se\u00e7\u00f5es!");
        }
        if (section.getDam() == null || section.getDam().getId() == null) {
            throw new InvalidInputException("Barragem da se\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (this.sectionRepository.findByDamIdAndName(section.getDam().getId(), section.getName()).isPresent()) {
            throw new DuplicateResourceException("J\u00e1 existe uma se\u00e7\u00e3o com esse nome para esta barragem.");
        }
        SectionEntity savedSection = (SectionEntity)this.sectionRepository.save((Object)section);
        log.info("Nova se\u00e7\u00e3o criada: {}", (Object)savedSection.getName());
        return savedSection;
    }

    @Transactional
    public SectionEntity createWithFile(CreateSectionDTO dto, MultipartFile file) {
        if (dto.getDamId() == null) {
            throw new InvalidInputException("Barragem da se\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (this.sectionRepository.findByDamIdAndName(dto.getDamId(), dto.getName()).isPresent()) {
            throw new DuplicateResourceException("J\u00e1 existe uma se\u00e7\u00e3o com esse nome para esta barragem.");
        }
        String originalFilename = file.getOriginalFilename();
        if (originalFilename != null) {
            String extension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1).toLowerCase();
            if (!extension.equals("dwg") && !extension.equals("dxf")) {
                throw new InvalidInputException("Tipo de arquivo n\u00e3o suportado. Apenas arquivos .dwg e .dxf s\u00e3o permitidos.");
            }
        } else {
            throw new InvalidInputException("Nome de arquivo inv\u00e1lido");
        }
        String filePath = this.fileStorageService.storeFile(file, "sections");
        SectionEntity section = new SectionEntity();
        section.setName(dto.getName());
        section.setFilePath(filePath);
        section.setFirstVertexLatitude(dto.getFirstVertexLatitude());
        section.setSecondVertexLatitude(dto.getSecondVertexLatitude());
        section.setFirstVertexLongitude(dto.getFirstVertexLongitude());
        section.setSecondVertexLongitude(dto.getSecondVertexLongitude());
        SectionEntity savedSection = (SectionEntity)this.sectionRepository.save((Object)section);
        log.info("Nova se\u00e7\u00e3o criada com arquivo: {}", (Object)savedSection.getName());
        return savedSection;
    }

    @Transactional
    public SectionEntity updateWithFile(Long id, CreateSectionDTO dto, MultipartFile file) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getEditSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a editar se\u00e7\u00f5es!");
        }
        SectionEntity existingSection = this.findById(id);
        if (dto.getDamId() == null) {
            throw new InvalidInputException("Barragem da se\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (!(existingSection.getName().equals(dto.getName()) && existingSection.getDam().getId().equals(dto.getDamId()) || !this.sectionRepository.findByDamIdAndName(dto.getDamId(), dto.getName()).isPresent())) {
            throw new DuplicateResourceException("J\u00e1 existe uma se\u00e7\u00e3o com esse nome para esta barragem.");
        }
        if (existingSection.getFilePath() != null && !existingSection.getFilePath().isEmpty()) {
            this.fileStorageService.deleteFile(existingSection.getFilePath());
        }
        if (file != null && !file.isEmpty()) {
            String originalFilename = file.getOriginalFilename();
            if (originalFilename != null) {
                String extension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1).toLowerCase();
                if (!extension.equals("dwg") && !extension.equals("dxf")) {
                    throw new InvalidInputException("Tipo de arquivo n\u00e3o suportado. Apenas arquivos .dwg e .dxf s\u00e3o permitidos.");
                }
            } else {
                throw new InvalidInputException("Nome de arquivo inv\u00e1lido");
            }
            String filePath = this.fileStorageService.storeFile(file, "sections");
            existingSection.setFilePath(filePath);
        }
        existingSection.setName(dto.getName());
        existingSection.setFirstVertexLatitude(dto.getFirstVertexLatitude());
        existingSection.setSecondVertexLatitude(dto.getSecondVertexLatitude());
        existingSection.setFirstVertexLongitude(dto.getFirstVertexLongitude());
        existingSection.setSecondVertexLongitude(dto.getSecondVertexLongitude());
        SectionEntity updatedSection = (SectionEntity)this.sectionRepository.save((Object)existingSection);
        log.info("Se\u00e7\u00e3o atualizada com arquivo: {}", (Object)updatedSection.getName());
        return updatedSection;
    }

    @Transactional
    public SectionEntity update(Long id, SectionEntity section) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getEditSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a editar se\u00e7\u00f5es!");
        }
        SectionEntity existingSection = this.findById(id);
        if (section.getDam() == null || section.getDam().getId() == null) {
            throw new InvalidInputException("Barragem da se\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (!(existingSection.getName().equals(section.getName()) && existingSection.getDam().getId().equals(section.getDam().getId()) || !this.sectionRepository.findByDamIdAndName(section.getDam().getId(), section.getName()).isPresent())) {
            throw new DuplicateResourceException("J\u00e1 existe uma se\u00e7\u00e3o com esse nome para esta barragem.");
        }
        existingSection.setName(section.getName());
        existingSection.setFilePath(section.getFilePath());
        existingSection.setFirstVertexLatitude(section.getFirstVertexLatitude());
        existingSection.setSecondVertexLatitude(section.getSecondVertexLatitude());
        existingSection.setFirstVertexLongitude(section.getFirstVertexLongitude());
        existingSection.setSecondVertexLongitude(section.getSecondVertexLongitude());
        SectionEntity updatedSection = (SectionEntity)this.sectionRepository.save((Object)existingSection);
        log.info("Se\u00e7\u00e3o atualizada: {}", (Object)updatedSection.getName());
        return updatedSection;
    }

    @Transactional
    public void delete(Long id) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getEditSections().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a excluir se\u00e7\u00f5es!");
        }
        SectionEntity section = this.findById(id);
        if (!section.getInstruments().isEmpty()) {
            throw new BusinessRuleException("N\u00e3o \u00e9 poss\u00edvel excluir uma se\u00e7\u00e3o que possui instrumentos associados");
        }
        if (section.getFilePath() != null && !section.getFilePath().isEmpty()) {
            this.fileStorageService.deleteFile(section.getFilePath());
        }
        if (section.getDam() != null) {
            section.getDam().getSections().remove(section);
            section.setDam(null);
        }
        this.sectionRepository.delete((Object)section);
        log.info("Se\u00e7\u00e3o exclu\u00edda: {}", (Object)section.getName());
    }

    @Generated
    public SectionService(SectionRepository sectionRepository, FileStorageService fileStorageService) {
        this.sectionRepository = sectionRepository;
        this.fileStorageService = fileStorageService;
    }
}

