/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.regulatory_dam.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.RegulatoryDamEntity;
import com.geosegbar.infra.regulatory_dam.dtos.RegulatoryDamDTO;
import com.geosegbar.infra.regulatory_dam.services.RegulatoryDamService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/regulatory-dam"})
public class RegulatoryDamController {
    private final RegulatoryDamService regulatoryDamService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<RegulatoryDamEntity>>> getAllRegulatoryDams() {
        List regulatoryDams = this.regulatoryDamService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)regulatoryDams, (String)"Informa\u00e7\u00f5es regulat\u00f3rias das barragens obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<RegulatoryDamEntity>> getRegulatoryDamById(@PathVariable Long id) {
        RegulatoryDamEntity regulatoryDam = this.regulatoryDamService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)regulatoryDam, (String)"Informa\u00e7\u00e3o regulat\u00f3ria da barragem obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<RegulatoryDamEntity>> getRegulatoryDamByDamId(@PathVariable Long damId) {
        RegulatoryDamEntity regulatoryDam = this.regulatoryDamService.findByDamId(damId);
        WebResponseEntity response = WebResponseEntity.success((Object)regulatoryDam, (String)"Informa\u00e7\u00e3o regulat\u00f3ria da barragem obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<RegulatoryDamEntity>> createRegulatoryDam(@Valid @RequestBody RegulatoryDamDTO regulatoryDamDTO) {
        RegulatoryDamEntity createdRegulatoryDam = this.regulatoryDamService.createOrUpdate(regulatoryDamDTO);
        WebResponseEntity response = WebResponseEntity.success((Object)createdRegulatoryDam, (String)"Informa\u00e7\u00e3o regulat\u00f3ria da barragem criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<RegulatoryDamEntity>> updateRegulatoryDam(@PathVariable Long id, @Valid @RequestBody RegulatoryDamDTO regulatoryDamDTO) {
        regulatoryDamDTO.setId(id);
        RegulatoryDamEntity updatedRegulatoryDam = this.regulatoryDamService.createOrUpdate(regulatoryDamDTO);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedRegulatoryDam, (String)"Informa\u00e7\u00e3o regulat\u00f3ria da barragem atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteRegulatoryDam(@PathVariable Long id) {
        this.regulatoryDamService.delete(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Informa\u00e7\u00e3o regulat\u00f3ria da barragem exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public RegulatoryDamController(RegulatoryDamService regulatoryDamService) {
        this.regulatoryDamService = regulatoryDamService;
    }
}

