/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.reading.persistence.jpa;

import com.geosegbar.common.enums.LimitStatusEnum;
import com.geosegbar.entities.ReadingEntity;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ReadingRepository
extends JpaRepository<ReadingEntity, Long> {
    public boolean existsByInstrumentIdAndDate(Long var1, LocalDate var2);

    public boolean existsByInstrumentIdAndDateAndHourAndActive(Long var1, LocalDate var2, LocalTime var3, Boolean var4);

    public List<ReadingEntity> findByInstrumentId(Long var1);

    public Page<ReadingEntity> findByInstrumentId(Long var1, Pageable var2);

    public List<ReadingEntity> findByOutputId(Long var1);

    public Page<ReadingEntity> findByOutputId(Long var1, Pageable var2);

    public List<ReadingEntity> findByInstrumentIdAndDateBetween(Long var1, LocalDate var2, LocalDate var3);

    public Page<ReadingEntity> findByInstrumentIdAndDateBetween(Long var1, LocalDate var2, LocalDate var3, Pageable var4);

    public List<ReadingEntity> findByInstrumentIdAndLimitStatus(Long var1, LimitStatusEnum var2);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.date = :date AND r.hour = :hour AND r.active = true")
    public List<ReadingEntity> findByInstrumentIdAndDateAndHourActiveTrue(@Param(value="instrumentId") Long var1, @Param(value="date") LocalDate var2, @Param(value="hour") LocalTime var3);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.date = :date AND r.hour = :hour AND r.active = true AND (r.date != :excludeDate OR r.hour != :excludeHour)")
    public List<ReadingEntity> findByInstrumentIdAndDateAndHourExcludingSpecific(@Param(value="instrumentId") Long var1, @Param(value="date") LocalDate var2, @Param(value="hour") LocalTime var3, @Param(value="excludeDate") LocalDate var4, @Param(value="excludeHour") LocalTime var5);

    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.date = :date AND r.hour = :hour AND r.active = true")
    public List<ReadingEntity> findAllReadingsInGroup(@Param(value="instrumentId") Long var1, @Param(value="date") LocalDate var2, @Param(value="hour") LocalTime var3);

    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public List<ReadingEntity> findByInstrumentIdOrderByDateDescHourDesc(@Param(value="instrumentId") Long var1);

    public Page<ReadingEntity> findByInstrumentIdOrderByDateDescHourDesc(Long var1, Pageable var2);

    @Query(value="SELECT r FROM ReadingEntity r WHERE r.output.id = :outputId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public List<ReadingEntity> findByOutputIdOrderByDateDescHourDesc(@Param(value="outputId") Long var1);

    public Page<ReadingEntity> findByOutputIdOrderByDateDescHourDesc(Long var1, Pageable var2);

    public List<ReadingEntity> findByInstrumentIdAndDateBetweenOrderByDateDescHourDesc(Long var1, LocalDate var2, LocalDate var3);

    public Page<ReadingEntity> findByInstrumentIdAndDateBetweenOrderByDateDescHourDesc(Long var1, LocalDate var2, LocalDate var3, Pageable var4);

    public List<ReadingEntity> findByInstrumentIdAndLimitStatusOrderByDateDescHourDesc(Long var1, LimitStatusEnum var2);

    @Query(value="SELECT r.date, r.hour FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND (:active IS NULL OR r.active = :active) GROUP BY r.date, r.hour ORDER BY r.date DESC, r.hour DESC")
    public Page<Object[]> findDistinctDateHourByInstrumentIdAndActive(@Param(value="instrumentId") Long var1, @Param(value="active") Boolean var2, Pageable var3);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.date = :date AND r.hour = :hour AND (:active IS NULL OR r.active = :active)")
    public List<ReadingEntity> findByInstrumentIdAndDateAndHourAndActive(@Param(value="instrumentId") Long var1, @Param(value="date") LocalDate var2, @Param(value="hour") LocalTime var3, @Param(value="active") Boolean var4);

    public List<ReadingEntity> findByInstrumentIdAndDateAndHourAndActiveTrue(Long var1, LocalDate var2, LocalTime var3);

    public List<ReadingEntity> findByInstrumentIdAndDateAndHour(Long var1, LocalDate var2, LocalTime var3);

    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.date = :date AND r.hour = :hour AND r.user.id = :userId AND r.active = true")
    public List<ReadingEntity> findByInstrumentAndDateAndHourAndUser(@Param(value="instrumentId") Long var1, @Param(value="date") LocalDate var2, @Param(value="hour") LocalTime var3, @Param(value="userId") Long var4);

    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND (:outputId IS NULL OR r.output.id = :outputId) AND (:startDate IS NULL OR r.date >= :startDate) AND (:endDate IS NULL OR r.date <= :endDate) AND (:limitStatus IS NULL OR r.limitStatus = :limitStatus) AND (:active IS NULL OR r.active = :active) ORDER BY r.date DESC, r.hour DESC")
    public Page<ReadingEntity> findByFilters(@Param(value="instrumentId") Long var1, @Param(value="outputId") Long var2, @Param(value="startDate") LocalDate var3, @Param(value="endDate") LocalDate var4, @Param(value="limitStatus") LimitStatusEnum var5, @Param(value="active") Boolean var6, Pageable var7);

    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public List<ReadingEntity> findTopNByInstrumentIdOrderByDateDescHourDesc(@Param(value="instrumentId") Long var1, Pageable var2);

    @Query(value="SELECT DISTINCT r.instrument.id FROM ReadingEntity r WHERE r.instrument.dam.client.id = :clientId AND r.active = true")
    public List<Long> findDistinctInstrumentIdsByClientId(@Param(value="clientId") Long var1);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public List<ReadingEntity> findByInstrumentIdOptimized(@Param(value="instrumentId") Long var1);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public Page<ReadingEntity> findByInstrumentIdOptimized(@Param(value="instrumentId") Long var1, Pageable var2);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.output.id = :outputId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public List<ReadingEntity> findByOutputIdOptimized(@Param(value="outputId") Long var1);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND (:outputId IS NULL OR r.output.id = :outputId) AND (:startDate IS NULL OR r.date >= :startDate) AND (:endDate IS NULL OR r.date <= :endDate) AND (:limitStatus IS NULL OR r.limitStatus = :limitStatus) AND (:active IS NULL OR r.active = :active) ORDER BY r.date DESC, r.hour DESC")
    public Page<ReadingEntity> findByFiltersOptimized(@Param(value="instrumentId") Long var1, @Param(value="outputId") Long var2, @Param(value="startDate") LocalDate var3, @Param(value="endDate") LocalDate var4, @Param(value="limitStatus") LimitStatusEnum var5, @Param(value="active") Boolean var6, Pageable var7);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public List<ReadingEntity> findTopNByInstrumentIdOptimized(@Param(value="instrumentId") Long var1, Pageable var2);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id IN :instrumentIds AND (:startDate IS NULL OR r.date >= :startDate) AND (:endDate IS NULL OR r.date <= :endDate) AND (:limitStatus IS NULL OR r.limitStatus = :limitStatus) AND (:active IS NULL OR r.active = :active) ORDER BY r.date DESC, r.hour DESC")
    public Page<ReadingEntity> findByMultipleInstrumentsWithFilters(@Param(value="instrumentIds") List<Long> var1, @Param(value="startDate") LocalDate var2, @Param(value="endDate") LocalDate var3, @Param(value="limitStatus") LimitStatusEnum var4, @Param(value="active") Boolean var5, Pageable var6);

    @Query(value="SELECT DISTINCT r.date, r.hour FROM ReadingEntity r WHERE r.instrument.id IN :instrumentIds AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public Page<Object[]> findDistinctDateHourByMultipleInstrumentIds(@Param(value="instrumentIds") List<Long> var1, Pageable var2);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id IN :instrumentIds AND r.date = :date AND r.hour = :hour AND r.active = true ORDER BY r.instrument.id, r.output.id")
    public List<ReadingEntity> findByMultipleInstrumentIdsAndDateAndHourAndActiveTrue(@Param(value="instrumentIds") List<Long> var1, @Param(value="date") LocalDate var2, @Param(value="hour") LocalTime var3);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    @Query(value="SELECT r FROM ReadingEntity r WHERE r.instrument.id = :instrumentId AND r.active = true ORDER BY r.date DESC, r.hour DESC")
    public List<ReadingEntity> findLatestReadingsByInstrumentId(@Param(value="instrumentId") Long var1, Pageable var2);

    @Query(value="SELECT DISTINCT o.instrument.id FROM OutputEntity o WHERE o.id IN :outputIds")
    public Set<Long> findInstrumentIdsByOutputIds(@Param(value="outputIds") List<Long> var1);

    @Query(value="SELECT r.id FROM reading r WHERE r.instrument_id = :instrumentId AND r.active = true ORDER BY r.date DESC, r.hour DESC LIMIT :limit", nativeQuery=true)
    public List<Long> findLatestReadingIdsByInstrumentId(@Param(value="instrumentId") Long var1, @Param(value="limit") int var2);

    @Query(value="SELECT r.id FROM reading r WHERE r.instrument_id = :instrumentId AND r.date >= :startDate AND r.active = true ORDER BY r.date DESC, r.hour DESC LIMIT :limit", nativeQuery=true)
    public List<Long> findLatestReadingIdsByInstrumentIdAndStartDate(@Param(value="instrumentId") Long var1, @Param(value="startDate") LocalDate var2, @Param(value="limit") int var3);

    @Query(value="SELECT r.id FROM reading r WHERE r.instrument_id = :instrumentId AND r.date <= :endDate AND r.active = true ORDER BY r.date DESC, r.hour DESC LIMIT :limit", nativeQuery=true)
    public List<Long> findLatestReadingIdsByInstrumentIdAndEndDate(@Param(value="instrumentId") Long var1, @Param(value="endDate") LocalDate var2, @Param(value="limit") int var3);

    @Query(value="SELECT r.id FROM reading r WHERE r.instrument_id = :instrumentId AND r.date >= :startDate AND r.date <= :endDate AND r.active = true ORDER BY r.date DESC, r.hour DESC LIMIT :limit", nativeQuery=true)
    public List<Long> findLatestReadingIdsByInstrumentIdAndDateRange(@Param(value="instrumentId") Long var1, @Param(value="startDate") LocalDate var2, @Param(value="endDate") LocalDate var3, @Param(value="limit") int var4);

    @EntityGraph(attributePaths={"user", "instrument", "output", "inputValues"})
    public List<ReadingEntity> findByIdIn(List<Long> var1);

    @Query(value="WITH instrument_ids AS (\n    SELECT DISTINCT i.id\n    FROM instrument i\n    JOIN dam d ON i.dam_id = d.id\n    WHERE d.client_id = :clientId\n    AND i.active = true\n),\ndistinct_date_hours AS (\n    SELECT r.instrument_id, r.date, r.hour,\n           ROW_NUMBER() OVER (PARTITION BY r.instrument_id ORDER BY r.date DESC, r.hour DESC) as row_num\n    FROM reading r\n    JOIN instrument_ids ii ON r.instrument_id = ii.id\n    WHERE r.active = true\n    GROUP BY r.instrument_id, r.date, r.hour\n)\nSELECT instrument_id, date, hour\nFROM distinct_date_hours\nWHERE row_num <= :limit\nORDER BY instrument_id, row_num\n", nativeQuery=true)
    public List<Object[]> findLatestDistinctDateHoursByClientId(@Param(value="clientId") Long var1, @Param(value="limit") int var2);
}

