/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.routine_inspection_permission.services;

import com.geosegbar.entities.RoutineInspectionPermissionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.permissions.routine_inspection_permission.dtos.RoutineInspectionPermissionDTO;
import com.geosegbar.infra.permissions.routine_inspection_permission.persistence.RoutineInspectionPermissionRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoutineInspectionPermissionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoutineInspectionPermissionService.class);
    private final RoutineInspectionPermissionRepository routinePermissionRepository;
    private final UserRepository userRepository;

    public List<RoutineInspectionPermissionEntity> findAll() {
        return this.routinePermissionRepository.findAll();
    }

    public RoutineInspectionPermissionEntity findById(Long id) {
        return (RoutineInspectionPermissionEntity)this.routinePermissionRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de inspe\u00e7\u00e3o de rotina n\u00e3o encontrada com ID: " + id));
    }

    public RoutineInspectionPermissionEntity findByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        return (RoutineInspectionPermissionEntity)this.routinePermissionRepository.findByUser(user).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de inspe\u00e7\u00e3o de rotina n\u00e3o encontrada para o usu\u00e1rio"));
    }

    @Transactional
    public RoutineInspectionPermissionEntity createOrUpdate(RoutineInspectionPermissionDTO permissionDTO) {
        RoutineInspectionPermissionEntity permission;
        UserEntity user = (UserEntity)this.userRepository.findById((Object)permissionDTO.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + permissionDTO.getUserId()));
        Optional existingPermission = this.routinePermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = (RoutineInspectionPermissionEntity)existingPermission.get();
        } else {
            permission = new RoutineInspectionPermissionEntity();
            permission.setUser(user);
        }
        permission.setIsFillWeb(permissionDTO.getIsFillWeb());
        permission.setIsFillMobile(permissionDTO.getIsFillMobile());
        return (RoutineInspectionPermissionEntity)this.routinePermissionRepository.save((Object)permission);
    }

    @Transactional
    public void delete(Long id) {
        if (!this.routinePermissionRepository.existsById((Object)id)) {
            throw new NotFoundException("Permiss\u00e3o de inspe\u00e7\u00e3o de rotina n\u00e3o encontrada com ID: " + id);
        }
        this.routinePermissionRepository.deleteById((Object)id);
    }

    @Transactional
    public void deleteByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        if (!this.routinePermissionRepository.existsByUser(user)) {
            throw new NotFoundException("Permiss\u00e3o de inspe\u00e7\u00e3o de rotina n\u00e3o encontrada para o usu\u00e1rio");
        }
        RoutineInspectionPermissionEntity permission = (RoutineInspectionPermissionEntity)this.routinePermissionRepository.findByUser(user).get();
        permission.setUser(null);
        this.routinePermissionRepository.delete((Object)permission);
    }

    @Transactional
    public void deleteByUserSafely(Long userId) {
        try {
            UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
            if (this.routinePermissionRepository.existsByUser(user)) {
                RoutineInspectionPermissionEntity permission = (RoutineInspectionPermissionEntity)this.routinePermissionRepository.findByUser(user).get();
                user.setRoutineInspectionPermission(null);
                permission.setUser(null);
                this.userRepository.save((Object)user);
                this.routinePermissionRepository.save((Object)permission);
                this.routinePermissionRepository.delete((Object)permission);
            } else {
                log.info("No routine inspection permission found for user {}", (Object)userId);
            }
        }
        catch (Exception e) {
            log.error("Error while trying to delete routine inspection permission for user {}: {}", new Object[]{userId, e.getMessage(), e});
        }
    }

    @Transactional
    public RoutineInspectionPermissionEntity createDefaultPermission(UserEntity user) {
        if (this.routinePermissionRepository.existsByUser(user)) {
            return (RoutineInspectionPermissionEntity)this.routinePermissionRepository.findByUser(user).get();
        }
        RoutineInspectionPermissionEntity permission = new RoutineInspectionPermissionEntity();
        permission.setUser(user);
        permission.setIsFillWeb(Boolean.valueOf(false));
        permission.setIsFillMobile(Boolean.valueOf(false));
        RoutineInspectionPermissionEntity savedPermission = (RoutineInspectionPermissionEntity)this.routinePermissionRepository.save((Object)permission);
        return savedPermission;
    }

    @Generated
    public RoutineInspectionPermissionService(RoutineInspectionPermissionRepository routinePermissionRepository, UserRepository userRepository) {
        this.routinePermissionRepository = routinePermissionRepository;
        this.userRepository = userRepository;
    }
}

