/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_customization_properties.persistence.jpa;

import com.geosegbar.common.enums.CustomizationTypeEnum;
import com.geosegbar.common.enums.LimitValueTypeEnum;
import com.geosegbar.common.enums.LineTypeEnum;
import com.geosegbar.entities.InstrumentGraphCustomizationPropertiesEntity;
import jakarta.persistence.QueryHint;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstrumentGraphCustomizationPropertiesRepository
extends JpaRepository<InstrumentGraphCustomizationPropertiesEntity, Long> {
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentGraphCustomizationPropertiesEntity p LEFT JOIN FETCH p.output o LEFT JOIN FETCH p.statisticalLimit sl LEFT JOIN FETCH p.deterministicLimit dl LEFT JOIN FETCH p.instrument i WHERE p.pattern.id = :patternId")
    public List<InstrumentGraphCustomizationPropertiesEntity> findByPatternId(@Param(value="patternId") Long var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByConstantId(Long var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByCustomizationType(CustomizationTypeEnum var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByPatternIdAndCustomizationType(Long var1, CustomizationTypeEnum var2);

    public Optional<InstrumentGraphCustomizationPropertiesEntity> findByNameAndPatternId(String var1, Long var2);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByOutputId(Long var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByStatisticalLimitId(Long var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByDeterministicLimitId(Long var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByInstrumentId(Long var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByLabelEnableTrue();

    public List<InstrumentGraphCustomizationPropertiesEntity> findByIsPrimaryOrdinateTrue();

    public List<InstrumentGraphCustomizationPropertiesEntity> findByIsPrimaryOrdinateFalse();

    public List<InstrumentGraphCustomizationPropertiesEntity> findByFillColor(String var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByLineType(LineTypeEnum var1);

    public boolean existsByNameAndPatternId(String var1, Long var2);

    @Query(value="SELECT p FROM InstrumentGraphCustomizationPropertiesEntity p WHERE p.pattern.instrument.id = :instrumentId")
    public List<InstrumentGraphCustomizationPropertiesEntity> findByPatternInstrumentId(@Param(value="instrumentId") Long var1);

    public void deleteByPatternId(Long var1);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByPatternIdAndStatisticalLimitIdAndLimitValueType(Long var1, Long var2, LimitValueTypeEnum var3);

    public List<InstrumentGraphCustomizationPropertiesEntity> findByPatternIdAndDeterministicLimitIdAndLimitValueType(Long var1, Long var2, LimitValueTypeEnum var3);

    @Query(value="SELECT p FROM InstrumentGraphCustomizationPropertiesEntity p WHERE p.pattern.id = :patternId AND p.customizationType = 'STATISTICAL_LIMIT' AND p.statisticalLimit.id = :limitId")
    public List<InstrumentGraphCustomizationPropertiesEntity> findStatisticalLimitPropertiesByPatternAndLimit(@Param(value="patternId") Long var1, @Param(value="limitId") Long var2);

    @Query(value="SELECT p FROM InstrumentGraphCustomizationPropertiesEntity p WHERE p.pattern.id = :patternId AND p.customizationType = 'DETERMINISTIC_LIMIT' AND p.deterministicLimit.id = :limitId")
    public List<InstrumentGraphCustomizationPropertiesEntity> findDeterministicLimitPropertiesByPatternAndLimit(@Param(value="patternId") Long var1, @Param(value="limitId") Long var2);
}

